package org.gcube.portlets.user.tdwx.client.config;

import java.util.Collections;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Event;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.widget.core.client.event.RowClickEvent;
import com.sencha.gxt.widget.core.client.event.RowMouseDownEvent;
import com.sencha.gxt.widget.core.client.event.XEvent;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.selection.CellSelection;


/**
 * Extends the GridSelectionModel to retrieve the selected cell. 
 * CellSelectionModel is not suitable.
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 * @param <M>
 */
public class GridAndCellSelectionModel<M> extends GridSelectionModel<M> {
	
	protected CellSelection<M> cellSelected;
	
	public GridAndCellSelectionModel() {
		super();
	}

	/**
	 * Handles a row click event. The row click event is responsible for adding
	 * to a selection in multiple selection mode.
	 * 
	 * @param event
	 *            the row click event
	 */
	@Override
	protected void handleRowClick(RowClickEvent event) {
		if (Element.is(event.getEvent().getEventTarget())
				&& !grid.getView().isSelectableTarget(
						Element.as(event.getEvent().getEventTarget()))) {
			return;
		}
		if (isLocked()) {
			return;
		}

		if (fireSelectionChangeOnClick) {
			fireSelectionChange();
			fireSelectionChangeOnClick = false;
		}

		XEvent xe = event.getEvent().<XEvent> cast();

		int rowIndex = event.getRowIndex();
		int colIndex = event.getColumnIndex();
		if (rowIndex == -1) {
			deselectAll();
			return;
		}
		if (selectionMode == SelectionMode.MULTI) {
			M sel = listStore.get(rowIndex);
			cellSelected=new CellSelection<M>(sel, rowIndex,colIndex);
			if (xe.getCtrlOrMetaKey() && isSelected(sel)) {
				doDeselect(Collections.singletonList(sel), false);
			} else if (xe.getCtrlOrMetaKey()) {
				grid.getView().focusCell(rowIndex, colIndex, false);
				doSelect(Collections.singletonList(sel), true, false);
			} else if (isSelected(sel) && !event.getEvent().getShiftKey()
					&& !xe.getCtrlOrMetaKey() && selected.size() > 1) {
				grid.getView().focusCell(rowIndex, colIndex, false);
				doSelect(Collections.singletonList(sel), false, false);
			}
		}

	}

	/**
	 * Handles a row mouse down event. The row mouse down event is responsible
	 * for initiating a selection.
	 * 
	 * @param event
	 *            the row mouse down event
	 */
	@Override
	protected void handleRowMouseDown(RowMouseDownEvent event) {
		if (Element.is(event.getEvent().getEventTarget())
				&& !grid.getView().isSelectableTarget(
						Element.as(event.getEvent().getEventTarget()))) {
			return;
		}
		if (isLocked()) {
			return;
		}
		int rowIndex = event.getRowIndex();
		int colIndex = event.getColumnIndex();
		if (rowIndex == -1) {
			return;
		}

		mouseDown = true;

		XEvent e = event.getEvent().<XEvent> cast();

		if (event.getEvent().getButton() == Event.BUTTON_RIGHT) {
			if (selectionMode != SelectionMode.SINGLE
					&& isSelected(listStore.get(rowIndex))) {
				M sel=listStore.get(rowIndex);
				cellSelected=new CellSelection<M>(sel, rowIndex,colIndex);
				return;
			}
			M sel=listStore.get(rowIndex);
			cellSelected=new CellSelection<M>(sel, rowIndex,colIndex);
			grid.getView().focusCell(rowIndex, colIndex, false);
			select(rowIndex, false);
		} else {
			M sel = listStore.get(rowIndex);
			if (selectionMode == SelectionMode.SIMPLE) {
				if (!isSelected(sel)) {
					grid.getView().focusCell(rowIndex, colIndex, false);
					cellSelected=new CellSelection<M>(sel, rowIndex,colIndex);
					select(sel, true);
				}

			} else if (selectionMode == SelectionMode.SINGLE) {
				if (e.getCtrlOrMetaKey() && isSelected(sel)) {
					deselect(sel);
				} else if (!isSelected(sel)) {
					grid.getView().focusCell(rowIndex, colIndex, false);
					cellSelected=new CellSelection<M>(sel, rowIndex,colIndex);
					select(sel, false);
				}
			} else if (!e.getCtrlOrMetaKey()) {
				if (event.getEvent().getShiftKey() && lastSelected != null) {
					int last = listStore.indexOf(lastSelected);
					int index = rowIndex;
					grid.getView().focusCell(index, colIndex, false);
					select(last, index, e.getCtrlOrMetaKey());
				} else if (!isSelected(sel)) {
					grid.getView().focusCell(rowIndex, colIndex, false);
					cellSelected=new CellSelection<M>(sel, rowIndex,colIndex);
					doSelect(Collections.singletonList(sel), false, false);
				}
			} else {
				// EXTGWT-2019 when inline editing for grid and tree grid with
				// row based
				// selection model focus is not
				// being moved to grid when clicking on another cell in same row
				// as
				// active edit and therefore
				// field is not bluring and firing change event
				grid.getView().focus();
			}
		}

		mouseDown = false;
	}

	public CellSelection<M> getCellSelected() {
		return cellSelected;
	}

	public void setCellSelected(CellSelection<M> cellSelected) {
		this.cellSelected = cellSelected;
	}

	

	
}
