package org.gcube.portlets.user.templates.client.components;

import org.gcube.portlets.d4sreporting.common.client.CommonConstants;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.client.uicomponents.ReportUIComponent;
import org.gcube.portlets.user.templates.client.TGenConstants;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;


/**
 * <code> DroppingArea </code> class is a Widget that can be placed in the UI Component
 *
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * @version October 2008 (0.2) 
 */
public class DroppingArea extends ReportUIComponent {
	
	private String expectedContent = "";
	
	private TextBox textbox = new TextBox();
	
	private DroppingArea myInstance;
	
	private Presenter presenter;
	
	private final static String DEFAULT_TEXT = "<expected content here>"; 

	/**
	 * 
	 * @param controller controller instance
	 * @param left l
	 * @param top t
	 * @param width width
	 * @param height height
	 * @param isImage tell if il will be a image or a text when in the report portlet
	 */
	public DroppingArea(final Presenter controller, final int left, final int top, final int width, final int height, boolean isDoubled) {
		super(ComponentType.DYNA_IMAGE, left, top, width, height);
	
		myInstance = this;
	
		this.setStyleName("droppingArea-Image");
		this.presenter = controller;
		
		VerticalPanel myPanel = getResizablePanel();
		myPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		myPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		HorizontalPanel oneLinePanel = new HorizontalPanel();
		
		myPanel.add(oneLinePanel);
		oneLinePanel.add(textbox);
		oneLinePanel.setWidth("75%");
		textbox.setWidth("95%");
		textbox.setHeight("18px");
		textbox.setStyleName("d4sInnerDragTextbox");

		addDefaultText();
	
		/**
		 * adding th eimage and its listener
		 */
		Image resizeImage = new Image(TGenConstants.RESIZE);
		if (! isDoubled ) {
			oneLinePanel.add(resizeImage);
		}
		
		resizeImage.setTitle("Click to change Image properties");
		resizeImage.setStyleName("selectable");
		resizeImage.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				Widget sender = (Widget) event.getSource();
				int x = sender.getAbsoluteLeft();
				int y = sender.getAbsoluteTop();
				GWT.log("X: " + x + "Y: " + y, null);
				
				final PopupPanel resizePopupPanel = new PopupPanel(true);
				resizePopupPanel.setPopupPosition(x, y);
				resizePopupPanel.setAnimationEnabled(true);
				Grid grid = new Grid(3, 2);
				
				Label lWidth = new Label("Width");
				Label lHeight = new Label("Height");
				
				final TextBox wTextbox = new TextBox();
				final TextBox hTextbox = new TextBox();
				wTextbox.setText(""+myInstance.width);
				hTextbox.setText(""+myInstance.height);
				wTextbox.setMaxLength(4);
				hTextbox.setMaxLength(4);
				
				grid.setCellPadding(5);
				
				grid.setWidget(0, 0, lWidth);
				grid.setWidget(0, 1, wTextbox);
				grid.setWidget(1, 0, lHeight);
				grid.setWidget(1, 1, hTextbox);
				
				Button cancel = new Button("Cancel");
				cancel.addClickHandler(new ClickHandler() {	public void onClick(ClickEvent event) {	resizePopupPanel.hide();	}	});
				Button apply = new Button("Apply");
				
				
				grid.setWidget(2, 0, cancel);
				grid.setWidget(2, 1, apply);
				
				resizePopupPanel.setWidget(grid);
				resizePopupPanel.show();
				
				apply.addClickHandler(new ClickHandler() {
					
					@Override
					public void onClick(ClickEvent event) {
						String toCheck = wTextbox.getText().trim().replaceAll(CommonConstants.ACCEPTED_CHARS_JUST_NUM, "");
						int newWidth = Integer.valueOf(toCheck).intValue();
						
						toCheck = hTextbox.getText().trim().replaceAll(CommonConstants.ACCEPTED_CHARS_JUST_NUM, "");
						int newHeight = Integer.valueOf(toCheck).intValue();
						if (newHeight > 1000 || newWidth > 1000) {
							Window.alert("Height or Width greater than 1000px");
							wTextbox.setText(""+myInstance.width);
							hTextbox.setText(""+myInstance.height);
							return;
						}
						else {	
							wTextbox.setText(""+newWidth);
							hTextbox.setText(""+newHeight);
							controller.resizeTemplateComponent(myInstance, newWidth, newHeight);
							resizePopupPanel.hide();
						}
						
					}
				});				
			}			
		});

		
		textbox.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				textbox.setText("");				
			}
		});
	}
	
	/**
	 * 
	 * just add the default text in the textbox
	 */
	private void addDefaultText() {
		textbox.setText(DEFAULT_TEXT);
	}
	
		/**
	 * 
	 * @return expectedContent
	 */
	public String getExpectedContent() {
		return expectedContent;
	}

	/**
	 * 
	 * @param expectedContent .
	 */
	public void setExpectedContent(String expectedContent) {
		this.expectedContent = expectedContent;
		if (expectedContent.compareTo("") != 0  && !expectedContent.startsWith("http"))
			textbox.setText(expectedContent);
	}

	@Override
	public void lockComponent(ReportUIComponent toLock, boolean locked) {
		presenter.lockComponent(this, locked);
	}

	@Override
	public void removeTemplateComponent(ReportUIComponent toRemove) {
		presenter.removeTemplateComponent(this);		
	}

}
