/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratorPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.user.templates.client.components.Coords;
import org.gcube.portlets.user.templates.client.components.DoubleColumnPanel;
import org.gcube.portlets.user.templates.client.components.DroppingArea;
import org.gcube.portlets.user.templates.client.components.FakeTextArea;
import org.gcube.portlets.user.templates.client.dialogs.ImageUploaderDialog;
import org.gcube.portlets.user.templates.client.model.TemplateComponent;
import org.gcube.portlets.user.templates.client.model.TemplateModel;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

public class WorkspacePanel
extends Composite {
    private TemplateModel templateModel;
    private Presenter controller;
    public static WorkspacePanel singleton = null;
    private boolean waitForNextOne = false;
    private Widget bufferedWidget;
    private FlowPanel mainLayout = new FlowPanel();

    public static WorkspacePanel get() {
        return singleton;
    }

    public WorkspacePanel(TemplateModel model, Presenter control) {
        singleton = this;
        this.controller = control;
        this.templateModel = model;
        this.mainLayout.setPixelSize(this.templateModel.getPageWidth(), this.templateModel.getPageHeight());
        this.mainLayout.setStyleName("wpFlow");
        this.initWidget((Widget)this.mainLayout);
    }

    public void addFirstTextArea() {
        FakeTextArea toAdd = new FakeTextArea(0, this.controller);
        TemplateComponent tc = new TemplateComponent(this.templateModel, 0, 0, 750, 25, this.templateModel.getCurrentPage(), ComponentType.FAKE_TEXTAREA, "", (Widget)toAdd);
        this.templateModel.addComponentToModel(tc, 0);
        this.addComponentToLayout((Widget)toAdd, true);
    }

    public int addComponentToLayout(Widget w, boolean isFakeTextArea) {
        int insertTo = this.controller.getSelectedIndex();
        GWT.log((String)("Inserting on " + insertTo), null);
        int toReturn = 0;
        if (insertTo >= 0) {
            this.mainLayout.insert(w, insertTo);
        } else {
            this.mainLayout.add(w);
        }
        toReturn = this.mainLayout.getWidgetIndex(w);
        if (isFakeTextArea) {
            this.controller.setCurrCursorPos(this.mainLayout.getWidgetCount());
        } else {
            this.controller.setCurrCursorPos(toReturn + 1);
        }
        return toReturn;
    }

    public int addComponentToLayoutSystem(Widget w, boolean isDoubleColumnLayout) {
        this.waitForNextOne = isDoubleColumnLayout;
        int insertTo = this.controller.getSelectedIndex();
        GWT.log((String)("Inserting on " + insertTo), null);
        int toReturn = 0;
        if (!this.waitForNextOne) {
            this.mainLayout.add(w);
            this.bufferedWidget = null;
            toReturn = this.mainLayout.getWidgetIndex(w);
        } else if (this.bufferedWidget == null) {
            this.bufferedWidget = w;
            GWT.log((String)"isDoubleColumnLayout buffering", null);
        } else {
            DoubleColumnPanel toAdd = new DoubleColumnPanel(this.bufferedWidget, w);
            this.mainLayout.add((Widget)toAdd);
            this.bufferedWidget = null;
            toReturn = this.mainLayout.getWidgetIndex((Widget)toAdd);
            GWT.log((String)"isDoubleColumnLayout adding", null);
        }
        this.controller.setCurrCursorPos(toReturn + 1);
        return toReturn;
    }

    public boolean removeComponentFromLayout(Widget w) {
        int index = this.mainLayout.getWidgetIndex(w);
        boolean toReturn = this.mainLayout.remove(w);
        this.controller.getModel().removeComponentFromModel(this.mainLayout.getWidget(index));
        this.mainLayout.remove(index);
        this.controller.setCurrCursorPos(this.mainLayout.getWidgetCount());
        return toReturn;
    }

    public void setModel(TemplateModel model) {
        this.templateModel = model;
    }

    public void resizeWorkspace(int width, int height) {
        this.mainLayout.setPixelSize(width, height);
    }

    public void openImageUploadDialog(Coords start, int width, int height, DroppingArea toRemove) {
        ImageUploaderDialog dlg = new ImageUploaderDialog(this.controller, start, width, height, toRemove);
        dlg.setAnimationEnabled(true);
        dlg.setPopupPosition(start.getX(), start.getY());
        dlg.show();
    }

    public void resizeWidget(Widget toResize, int newWidth, int newHeight) {
        if (toResize instanceof DroppingArea) {
            DroppingArea dp = (DroppingArea)toResize;
            dp.resizePanel(newWidth, newHeight);
        } else {
            toResize.setPixelSize(newWidth, newHeight);
        }
    }

    public void moveWidget(Widget toMove, int left, int top) {
    }

    public PopupPanel getResizePopup(Widget toResize) {
        PopupPanel simplePopup = new PopupPanel(true);
        int currWidth = toResize.getOffsetWidth() - 6;
        int currHeight = toResize.getOffsetHeight() - 6;
        simplePopup.setAnimationEnabled(true);
        DecoratorPanel deco = new DecoratorPanel();
        VerticalPanel layout = new VerticalPanel();
        layout.setSpacing(10);
        Grid grid = new Grid(2, 2);
        TextBox widthBox = new TextBox();
        widthBox.setText("" + currWidth);
        widthBox.setWidth("50");
        widthBox.setMaxLength(3);
        TextBox heighBox = new TextBox();
        heighBox.setText("" + currHeight);
        heighBox.setWidth("50");
        heighBox.setMaxLength(3);
        Label labelW = new Label("Width: ");
        Label labelH = new Label("Height:");
        grid.setWidget(0, 0, (Widget)labelW);
        grid.setWidget(0, 1, (Widget)widthBox);
        grid.setWidget(1, 0, (Widget)labelH);
        grid.setWidget(1, 1, (Widget)heighBox);
        Button cancelButton = new Button("Cancel", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button applyButton = new Button("Apply", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel buttonsContainer = new HorizontalPanel();
        buttonsContainer.setSpacing(10);
        buttonsContainer.add((Widget)cancelButton);
        buttonsContainer.add((Widget)applyButton);
        layout.add((Widget)grid);
        layout.add((Widget)buttonsContainer);
        deco.add((Widget)layout);
        simplePopup.add((Widget)deco);
        return simplePopup;
    }

    public FlowPanel getMainLayout() {
        return this.mainLayout;
    }

    public void setController(Presenter controller) {
        this.controller = controller;
    }

    public void mask() {
        this.mainLayout.setStyleName("wpFlow_background");
    }

    public void unmask() {
        this.mainLayout.setStyleName("wpFlow");
    }

    static /* synthetic */ Presenter access$000(WorkspacePanel x0) {
        return x0.controller;
    }
}

