package org.gcube.portlets.user.templates.client;

import org.gcube.portlets.d4sreporting.common.shared.SerializableModel;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The client side stub for the RPC service.
 */
@RemoteServiceRelativePath("greet")
public interface TemplateService extends RemoteService {

	/**
	 * 
	 * @param model .
	 */
	void saveTemplate(String basketidToSaveIn, SerializableModel model);
	/**
	 * 
	 * @return .
	 */
	String[] getUserTemplateNames();
	/**
	 * @param templateName .
	 * @return .
	 */
	SerializableModel readModel(String templateName, String templateObjectID,boolean isImporting);
	
	/**
	 * each portlet instance runs in a scope
	 * each portlet instance is used by a unique username from within the portal
	 * @return a String[2] containing the username in [0] and the scope in [1]
	 */
	String[] getUserAndScope();
	
	/**
	 * 
	 * @param model .
	 */
	void storeTemplateInSession(SerializableModel model);
	
	
	/**
	 * 
	 * @return the model previously stored in the session 
	 */
	SerializableModel readTemplateFromSession();
}
