package org.gcube.portlets.user.templates.client.components;

import java.util.ArrayList;

import org.gcube.portlets.d4sreporting.common.client.uicomponents.ReportUIComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.SerializableRepeatableSequence;
import org.gcube.portlets.d4sreporting.common.shared.SerializableComponent;
import org.gcube.portlets.user.templates.client.TGenConstants;
import org.gcube.portlets.user.templates.client.model.TemplateComponent;
import org.gcube.portlets.user.templates.client.model.TemplateModel;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.VerticalPanel;

public class RepeatableSequence extends ReportUIComponent {
	private ArrayList<TemplateComponent> groupedComponents = new ArrayList<TemplateComponent>();

	VerticalPanel myPanel;
	Presenter p;

	/**
	 * used to create a new empty repeatable sequence
	 * @param types
	 */
	public RepeatableSequence(Presenter p, TemplateModel model, ComponentType ... types) {		
		super(ComponentType.REPEAT_SEQUENCE, 0, 0, TemplateModel.TEMPLATE_WIDTH - 50, 100);
		this.p = p;
		myPanel = getResizablePanel();
		
		Coords start = p.getInsertionPoint();
		//*** insert the starting delimiter
		GroupingDelimiterArea toAdd = new GroupingDelimiterArea();		
		TemplateComponent delimiter = new TemplateComponent(model, 0, start.getY(), 
				TemplateModel.TEMPLATE_WIDTH, 25, model.getCurrentPage(), ComponentType.REPEAT_SEQUENCE_DELIMITER, "", toAdd);
		add(delimiter);
		height += 35;
		//***

		myPanel = getResizablePanel();
		int height = 0;
		//for each item of the repeat seq.
		for (int i = 0; i < types.length; i++) {
			switch (types[i]) {
			case HEADING_1:
				TemplateComponent h1 = p.createStaticTextArea(ComponentType.HEADING_1, TemplateModel.TEMPLATE_WIDTH - 50, 35, true);
				add(h1);
				break;
			case HEADING_2:
				TemplateComponent h2 = p.createStaticTextArea(ComponentType.HEADING_2, TemplateModel.TEMPLATE_WIDTH - 50, 35, true);
				add(h2);
				break;
			case HEADING_3:
				TemplateComponent h3 = p.createStaticTextArea(ComponentType.HEADING_3, TemplateModel.TEMPLATE_WIDTH - 50, 35, true);
				add(h3);
				break;
			case HEADING_4:
				TemplateComponent h4 = p.createStaticTextArea(ComponentType.HEADING_4, TemplateModel.TEMPLATE_WIDTH - 50, 35, true);
				add(h4);
				break;
			case HEADING_5:
				TemplateComponent h5 = p.createStaticTextArea(ComponentType.HEADING_5, TemplateModel.TEMPLATE_WIDTH - 50, 35, true);
				add(h5);
				break;
			case BODY:
				TemplateComponent body = p.createStaticTextArea(ComponentType.BODY, TemplateModel.TEMPLATE_WIDTH - 50, 50, true);
				height += 25; //body is higher than headings
				add(body);
				break;
			case IMAGE:
				TemplateComponent image = p.createDroppingArea(ComponentType.DYNA_IMAGE, TGenConstants.DEFAULT_IMAGE_WIDTH, TGenConstants.DEFAULT_IMAGE_HEIGHT, true);
				height += TGenConstants.DEFAULT_IMAGE_HEIGHT-35;
				add(image);
				break;
			case FLEX_TABLE:				
				TemplateComponent tableCompo = p.createTable(ComponentType.FLEX_TABLE, 2, 2);
				height += GenericTable.DEFAULT_HEIGHT;
				add(tableCompo);
				break;
			}
			height += 35;
			//add the spacer except for the last one
			if (i < types.length-1) {
				add(p.getGroupInnerArea());
				height += 6;
			}			
		}
		//insert the ending delimiter
		toAdd = new GroupingDelimiterArea();
		TemplateComponent delimiterEnd = new TemplateComponent(model, 0, start.getY(), TemplateModel.TEMPLATE_WIDTH, 25, 
				model.getCurrentPage(), ComponentType.REPEAT_SEQUENCE_DELIMITER, "", toAdd);
		add(delimiterEnd);
		height += 35;
		
		resizePanel(TemplateModel.TEMPLATE_WIDTH - 50, height);
	}
	/**
	 * constructor used by the system when reading the model 
	 * @param sRS
	 */
	public RepeatableSequence(Presenter p, SerializableRepeatableSequence sRS) {
		super(ComponentType.REPEAT_SEQUENCE, 0, 0, TemplateModel.TEMPLATE_WIDTH - 50, sRS.getHeight());
		this.p = p;
		myPanel = getResizablePanel();

		int size = sRS.getGroupedComponents().size();
		for (int j = 0; j < size; j++) {
			SerializableComponent sComp = sRS.getGroupedComponents().get(j);
			add(new TemplateComponent(p.getModel(), sComp, p, false));
		}
	}

	public void add(TemplateComponent toAdd) {
		groupedComponents.add(toAdd);
		GWT.log("ToAdd= getType " + toAdd.getType() + " locked?"+toAdd.isLocked());
		myPanel.add(toAdd.getContent());
	}

	@Override
	public void removeTemplateComponent(ReportUIComponent toRemove) {
		p.removeTemplateComponent(this);	

	}

	@Override
	public void lockComponent(ReportUIComponent toLock, boolean locked) {
	}

	public ArrayList<TemplateComponent> getGroupedComponents() {
		return groupedComponents;
	}

	public void setGroupedComponents(ArrayList<TemplateComponent> groupedComponents) {
		this.groupedComponents = groupedComponents;
	}
	
	public int getHeight() {
		return super.mainPanel.getOffsetHeight();
	}
}
