/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.topics.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portlets.user.topics.client.TopicService;
import org.gcube.portlets.user.topics.shared.HashTagAndOccurrence;
import org.gcube.portlets.user.topics.shared.HashtagsWrapper;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TopicServiceImpl
extends RemoteServiceServlet
implements TopicService {
    private static final Logger logger = LoggerFactory.getLogger(TopicServiceImpl.class);
    public static final String TEST_USER = "test.user";
    private static final String TEST_SCOPE = "/gcube/devsec/devVRE";
    private static final int WINDOW_SIZE_IN_MONTHS = 6;
    private DatabookStore store;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            logger.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    public HashtagsWrapper getHashtags() {
        ArrayList<String> hashtagsChart = new ArrayList<String>();
        ASLSession session = this.getASLSession();
        String userName = session.getUsername();
        String currentScope = session.getScope();
        boolean isInfrastructure = this.isInfrastructureScope();
        if (userName.compareTo("test.user") == 0) {
            logger.debug("Found " + userName + " returning nothing");
            return null;
        }
        long timestampStart = System.currentTimeMillis();
        Calendar referenceTime = Calendar.getInstance();
        int currentMonth = referenceTime.get(2);
        referenceTime.set(2, currentMonth - 6);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        logger.debug("Reference time for trending topics is " + format.format(referenceTime.getTime()));
        try {
            Map<String, Integer> hashtags;
            ArrayList<HashTagAndOccurrence> toSort = new ArrayList<HashTagAndOccurrence>();
            if (isInfrastructure) {
                logger.debug("****** retrieving hashtags for user VREs and site");
                hashtags = new HashMap();
                HashMap<String, List> hashtagsInVres = new HashMap<String, List>();
                LiferayGroupManager gm = new LiferayGroupManager();
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser user = um.getUserByUsername(userName);
                Set vresInPortal = gm.listGroupsByUserAndSite(user.getUserId(), this.getThreadLocalRequest().getServerName());
                logger.debug("Contexts in this site are per user " + vresInPortal);
                ArrayList<String> contexts = new ArrayList<String>();
                for (GCubeGroup gCubeGroup : vresInPortal) {
                    contexts.add(gm.getInfrastructureScope(gCubeGroup.getGroupId()));
                }
                for (String context : contexts) {
                    Map map = this.store.getVREHashtagsWithOccurrenceFilteredByTime(context, referenceTime.getTimeInMillis());
                    for (String hashtag : map.keySet()) {
                        if (hashtags.containsKey(hashtag)) {
                            int currentValue = (Integer)hashtags.get(hashtag);
                            int newValue = currentValue + (Integer)map.get(hashtag);
                            hashtags.remove(hashtag);
                            hashtags.put(hashtag, newValue);
                            List vres = (List)hashtagsInVres.get(hashtag);
                            vres.add(context);
                            hashtagsInVres.put(hashtag, vres);
                            continue;
                        }
                        hashtags.put(hashtag, (Integer)map.get(hashtag));
                        ArrayList<String> vres = new ArrayList<String>();
                        vres.add(context);
                        hashtagsInVres.put(hashtag, vres);
                    }
                }
                Map weights = this.evaluateWeight(hashtags, 6, currentMonth, referenceTime, null, hashtagsInVres);
                for (String hashtag : hashtags.keySet()) {
                    toSort.add(new HashTagAndOccurrence(hashtag, (Integer)hashtags.get(hashtag), ((Double)weights.get(hashtag)).doubleValue()));
                }
            } else {
                logger.debug("****** retrieving hashtags for scope " + currentScope);
                hashtags = this.store.getVREHashtagsWithOccurrenceFilteredByTime(currentScope, referenceTime.getTimeInMillis());
                Map weights = this.evaluateWeight(hashtags, 6, currentMonth, referenceTime, currentScope, null);
                for (String hashtag : hashtags.keySet()) {
                    toSort.add(new HashTagAndOccurrence(hashtag, (Integer)hashtags.get(hashtag), ((Double)weights.get(hashtag)).doubleValue()));
                }
            }
            logger.debug("Number of topics retrieved is " + toSort.size());
            Collections.sort(toSort);
            for (HashTagAndOccurrence wrapper : toSort) {
                logger.debug("Entry is " + wrapper.toString() + " with weight " + wrapper.getWeight());
                String hashtag = wrapper.getHashtag();
                String href = "\"?" + new String(Base64.encodeBase64((byte[])"hashtagIdentificationParameter".getBytes())) + "=" + new String(Base64.encodeBase64((byte[])hashtag.getBytes())) + "\"";
                String hashtagLink = "<a class=\"topiclink\" href=" + href + ">" + hashtag + "</a>";
                hashtagsChart.add(hashtagLink);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving hashtags ", (Throwable)e);
            return null;
        }
        long timestampEnd = System.currentTimeMillis() - timestampStart;
        logger.debug("Overall time to retrieve hastags is " + timestampEnd + "ms");
        return new HashtagsWrapper(isInfrastructure, hashtagsChart);
    }

    private Map<String, Double> evaluateWeight(Map<String, Integer> hashtags, int windowSize, int currentMonth, Calendar referenceTime, String vreId, Map<String, List<String>> hashtagsInVres) {
        HashMap<String, Double> weights = new HashMap<String, Double>();
        int max = 0;
        for (Map.Entry<String, Integer> entry : hashtags.entrySet()) {
            max = max < entry.getValue() ? entry.getValue() : max;
        }
        HashMap<String, Double> normalized = new HashMap<String, Double>();
        for (Map.Entry<String, Integer> entry : hashtags.entrySet()) {
            normalized.put(entry.getKey(), (double)entry.getValue().intValue() / (double)max);
        }
        for (Map.Entry<String, Integer> entry : hashtags.entrySet()) {
            ArrayList mostRecentFeedForHashtag;
            block11: {
                double weight = 0.6 * (Double)normalized.get(entry.getKey());
                mostRecentFeedForHashtag = null;
                if (vreId != null) {
                    try {
                        mostRecentFeedForHashtag = this.store.getVREFeedsByHashtag(vreId, entry.getKey());
                        break block11;
                    }
                    catch (Exception e) {
                        logger.error("Unable to retrieve the most recent feeds for hashtag " + entry.getKey() + " in " + vreId);
                        weights.put(entry.getKey(), 0.0);
                        continue;
                    }
                }
                List<String> vres = hashtagsInVres.get(entry.getKey());
                mostRecentFeedForHashtag = new ArrayList();
                for (String vre : vres) {
                    List feedsForVre;
                    try {
                        feedsForVre = this.store.getVREFeedsByHashtag(vre, entry.getKey());
                    }
                    catch (Exception e) {
                        logger.error("Unable to retrieve the most recent feeds for hashtag " + entry.getKey() + " in " + vreId);
                        continue;
                    }
                    mostRecentFeedForHashtag.addAll(feedsForVre);
                }
                if (mostRecentFeedForHashtag.isEmpty()) {
                    weights.put(entry.getKey(), 0.0);
                    continue;
                }
            }
            Collections.sort(mostRecentFeedForHashtag, Collections.reverseOrder());
            Calendar monstRecentFeedForHashTagTime = Calendar.getInstance();
            monstRecentFeedForHashTagTime.setTimeInMillis(((Feed)mostRecentFeedForHashtag.get(0)).getTime().getTime());
            int sub = currentMonth - monstRecentFeedForHashTagTime.get(2);
            int value = sub >= 0 ? sub : 12 - Math.abs(sub);
            double freshness = 1.0 - (double)value / (double)windowSize;
            logger.debug("freshness is " + freshness + " for hashtag " + entry.getKey() + " because the last feed has month " + monstRecentFeedForHashTagTime.get(2));
            weights.put(entry.getKey(), weight += 0.4 * freshness);
        }
        Map map = TopicServiceImpl.sortByWeight(weights);
        for (Map.Entry entry : map.entrySet()) {
            logger.debug("[hashtag=" + (String)entry.getKey() + " , weight=" + entry.getValue() + "]");
        }
        return weights;
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByWeight(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private boolean isInfrastructureScope() {
        boolean toReturn = false;
        try {
            LiferayGroupManager manager = new LiferayGroupManager();
            long groupId = manager.getGroupIdFromInfrastructureScope(this.getASLSession().getScope());
            toReturn = manager.isVRE(groupId) == false;
            return toReturn;
        }
        catch (Exception e) {
            logger.error("NullPointerException in isInfrastructureScope returning false");
            return false;
        }
    }
}

