/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.topics.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portlets.user.topics.client.TopicService;
import org.gcube.portlets.user.topics.shared.HashTagOccAndWeight;
import org.gcube.portlets.user.topics.shared.HashtagsWrapper;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicServiceImpl
extends RemoteServiceServlet
implements TopicService {
    private static final Logger logger = LoggerFactory.getLogger(TopicServiceImpl.class);
    public static final String TEST_USER = "test.user";
    private static final String TEST_SCOPE = "/gcube/devsec/devVRE";
    private static final int WINDOW_SIZE_IN_MONTHS = 6;
    private static final double FRESHNESS_FACTOR = 0.4;
    private static final double NORMALIZED_SCORE_FACTOR = 0.6;
    private DatabookStore store;
    private GroupManager gm;
    private UserManager um;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
        this.gm = new LiferayGroupManager();
        this.um = new LiferayUserManager();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            logger.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope(TEST_SCOPE);
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = TEST_USER;
        return user;
    }

    public HashtagsWrapper getHashtags() {
        ASLSession session = this.getASLSession();
        String userName = session.getUsername();
        if (userName.compareTo(TEST_USER) == 0) {
            logger.debug("Found " + userName + " returning nothing");
            return null;
        }
        String currentScope = session.getScope();
        boolean isInfrastructure = this.isInfrastructureScope(currentScope);
        Calendar referenceTime = Calendar.getInstance();
        int currentMonth = referenceTime.get(2);
        referenceTime.set(2, currentMonth - 6);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        logger.debug("Reference time for trending topics is " + format.format(referenceTime.getTime()));
        ArrayList<HashTagOccAndWeight> toSort = new ArrayList<HashTagOccAndWeight>();
        ArrayList<String> hashtagsChart = new ArrayList<String>();
        HashMap hashtagsInVres = null;
        try {
            Map<String, Integer> hashtagsAndOccurrences = new HashMap();
            if (isInfrastructure) {
                logger.debug("****** retrieving hashtags for user VREs and site");
                GCubeUser user = this.um.getUserByUsername(userName);
                Set vresInPortal = this.gm.listGroupsByUserAndSite(user.getUserId(), this.getThreadLocalRequest().getServerName());
                logger.debug("Contexts in this site per user are " + vresInPortal);
                ArrayList<String> contexts = new ArrayList<String>();
                for (GCubeGroup gCubeGroup : vresInPortal) {
                    contexts.add(this.gm.getInfrastructureScope(gCubeGroup.getGroupId()));
                }
                hashtagsInVres = new HashMap();
                for (String context : contexts) {
                    Map hashtagsAndOccurrenceInScope = this.store.getVREHashtagsWithOccurrenceFilteredByTime(context, referenceTime.getTimeInMillis());
                    for (String hashtag : hashtagsAndOccurrenceInScope.keySet()) {
                        int newValue;
                        List<String> vres = new ArrayList<String>();
                        if (hashtagsAndOccurrences.containsKey(hashtag)) {
                            newValue = (Integer)hashtagsAndOccurrences.get(hashtag) + (Integer)hashtagsAndOccurrenceInScope.get(hashtag);
                            vres = (List)hashtagsInVres.get(hashtag);
                        } else {
                            newValue = (Integer)hashtagsAndOccurrenceInScope.get(hashtag);
                        }
                        hashtagsAndOccurrences.put(hashtag, newValue);
                        vres.add(context);
                        hashtagsInVres.put(hashtag, vres);
                    }
                }
            } else {
                logger.debug("****** retrieving hashtags for scope " + currentScope);
                hashtagsAndOccurrences = this.store.getVREHashtagsWithOccurrenceFilteredByTime(currentScope, referenceTime.getTimeInMillis());
            }
            Map weights = this.evaluateWeights(hashtagsAndOccurrences, 6, currentMonth, referenceTime, currentScope, hashtagsInVres);
            for (String hashtag : hashtagsAndOccurrences.keySet()) {
                toSort.add(new HashTagOccAndWeight(hashtag, (Integer)hashtagsAndOccurrences.get(hashtag), ((Double)weights.get(hashtag)).doubleValue()));
            }
            Collections.sort(toSort);
            for (HashTagOccAndWeight wrapper : toSort) {
                logger.debug("Entry is " + wrapper.toString() + " with weight " + wrapper.getWeight());
                String hashtag = wrapper.getHashtag();
                String href = "\"?" + new String(Base64.encodeBase64((byte[])"hashtagIdentificationParameter".getBytes())) + "=" + new String(Base64.encodeBase64((byte[])hashtag.getBytes())) + "\"";
                String hashtagLink = "<a class=\"topiclink\" href=" + href + ">" + hashtag + "</a>";
                hashtagsChart.add(hashtagLink);
            }
            return new HashtagsWrapper(isInfrastructure, hashtagsChart);
        }
        catch (Exception e) {
            logger.error("Error while retrieving hashtags ", (Throwable)e);
            return null;
        }
    }

    private Map<String, Double> evaluateWeights(Map<String, Integer> hashtags, int windowSize, int currentMonth, Calendar referenceTime, String vreId, Map<String, List<String>> hashtagsInVres) {
        HashMap<String, Double> weights = new HashMap<String, Double>();
        int max = 0;
        for (Map.Entry<String, Integer> entry : hashtags.entrySet()) {
            max = max < entry.getValue() ? entry.getValue() : max;
        }
        HashMap<String, Double> normalized = new HashMap<String, Double>();
        for (Map.Entry<String, Integer> entry : hashtags.entrySet()) {
            normalized.put(entry.getKey(), (double)entry.getValue().intValue() / (double)max);
        }
        for (Map.Entry<String, Integer> entry : hashtags.entrySet()) {
            ArrayList mostRecentFeedForHashtag;
            block10: {
                double weight = 0.6 * (Double)normalized.get(entry.getKey());
                mostRecentFeedForHashtag = null;
                if (hashtagsInVres == null) {
                    try {
                        mostRecentFeedForHashtag = this.store.getVREFeedsByHashtag(vreId, entry.getKey());
                        break block10;
                    }
                    catch (Exception e) {
                        logger.error("Unable to retrieve the most recent feeds for hashtag " + entry.getKey() + " in " + vreId);
                        weights.put(entry.getKey(), 0.0);
                        continue;
                    }
                }
                List<String> vres = hashtagsInVres.get(entry.getKey());
                mostRecentFeedForHashtag = new ArrayList();
                for (String vre : vres) {
                    List feedsForVre;
                    try {
                        feedsForVre = this.store.getVREFeedsByHashtag(vre, entry.getKey());
                    }
                    catch (Exception e) {
                        logger.error("Unable to retrieve the most recent feeds for hashtag " + entry.getKey() + " in " + vreId);
                        continue;
                    }
                    mostRecentFeedForHashtag.addAll(feedsForVre);
                }
                if (mostRecentFeedForHashtag.isEmpty()) {
                    weights.put(entry.getKey(), 0.0);
                    continue;
                }
            }
            Collections.sort(mostRecentFeedForHashtag, Collections.reverseOrder());
            Calendar monstRecentFeedForHashTagTime = Calendar.getInstance();
            monstRecentFeedForHashTagTime.setTimeInMillis(((Feed)mostRecentFeedForHashtag.get(0)).getTime().getTime());
            int sub = currentMonth - monstRecentFeedForHashTagTime.get(2);
            int value = sub >= 0 ? sub : 12 - Math.abs(sub);
            double freshness = 1.0 - (double)value / (double)windowSize;
            logger.debug("freshness is " + freshness + " for hashtag " + entry.getKey() + " because the last feed has month " + monstRecentFeedForHashTagTime.get(2));
            weights.put(entry.getKey(), weight += 0.4 * freshness);
        }
        return weights;
    }

    private boolean isInfrastructureScope(String currentScope) {
        boolean toReturn = false;
        try {
            long groupId = this.gm.getGroupIdFromInfrastructureScope(currentScope);
            toReturn = this.gm.isVRE(groupId) == false;
            return toReturn;
        }
        catch (Exception e) {
            logger.error("NullPointerException in isInfrastructureScope returning false");
            return false;
        }
    }
}

