package org.gcube.portlets.user.uriresolvermanager.geoportal;

import java.net.MalformedURLException;
import java.net.URL;

import org.gcube.portlets.user.uriresolvermanager.entity.ServiceAccessPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoportalExporterAPI {

	private GeoportalExporterEndpoint endpoint;
	private ServiceAccessPoint serviceAccessPoint;
	
	private final String QUERY_PARAMETER_AS_URL = "as-url";

	public static final Logger LOG = LoggerFactory.getLogger(GeoportalExporterAPI.class);

	public static String DEFAULT_TYPE = "pdf";

	public GeoportalExporterAPI() throws Exception {
		this.endpoint = new GeoportalExporterEndpoint();
		this.serviceAccessPoint = this.endpoint.getServiceAccessPoint();
	}

	public URL exportProject(String type, String ucdID, String projectID, boolean asURL) throws MalformedURLException {
		if (type == null || type.isEmpty())
			type = DEFAULT_TYPE;

		String api = String.format("%s/export/%s/%s/%s", serviceAccessPoint.getServiceUrl(), type, ucdID, projectID);
		if(asURL)
			api+="?"+QUERY_PARAMETER_AS_URL+"="+asURL;
		
		LOG.info("returning exportProject API: " + api);
		return new URL(api);
	}

	public URL viewJob(String jobCode) throws MalformedURLException {
		String api = String.format("%s/view/%s", serviceAccessPoint.getServiceUrl(), jobCode);
		LOG.info("returning viewJob API: " + api);
		return new URL(api);
	}

	public URL healthcheck(String type) throws MalformedURLException {
		if (type == null || type.isEmpty())
			type = DEFAULT_TYPE;
		String api = String.format("%s/export/%s/healthcheck", serviceAccessPoint.getServiceUrl(), type);
		LOG.info("returning healthcheck API: " + api);
		return new URL(api);
	}

}
