package org.gcube.portlets.user.uriresolvermanager.geoportal;

import org.gcube.portlets.user.uriresolvermanager.entity.ServiceAccessPoint;
import org.gcube.portlets.user.uriresolvermanager.readers.RuntimeResourceReader;

/**
 * Represents the Geoportal Exporter endpoint.
 */
public class GeoportalExporterEndpoint {

    /**
     * The URI Resolver resource name.
     */
    public final String URI_RESOLVER_RESOURCE_NAME = "HTTP-URI-Resolver";
    /**
     * The entry point name for the Geoportal exporter.
     */
    public final String ENTRY_POINT_NAME = "geoportal_exp";

    /**
     * Default constructor.
     */
    public GeoportalExporterEndpoint()  {
    }

    /**
     * Gets the service access point for the Geoportal exporter.
     * @return The service access point.
     * @throws Exception if an error occurs while retrieving the access point.
     */
    public ServiceAccessPoint getServiceAccessPoint()throws Exception {
        RuntimeResourceReader runtimeRR = new RuntimeResourceReader(URI_RESOLVER_RESOURCE_NAME);
        return runtimeRR.getServiceAccessPointForEntryName(ENTRY_POINT_NAME);
    }

}
