package org.gcube.portlets.user.vlabs;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(
        immediate = true,
        service = IJournalArticleHelper.class
)
public class JournalArticleHelper implements IJournalArticleHelper {

    @Reference
    private JournalArticleLocalService journalArticleLocalService;

    public String getArticleContent(long groupId, long documentId) {
        try {
            if (documentId <= 0) return "";

            JournalArticle article = journalArticleLocalService.getArticle(groupId, "" + documentId);
            Document document = SAXReaderUtil.read(article.getContent());
            Node node = document.selectSingleNode("/root/static-content");
            return node.getText();
        } catch (Exception e) {
            return "";
        }
    }
}
