/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.vremembers.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.vremembers.client.ui.DisplayBadge;
import org.gcube.portlets.user.vremembers.shared.BelongingUser;

public class DisplayBadge
extends Composite {
    protected static final String HEADLINE_TEXT = "Professional Headline";
    protected static final String ISTI_TEXT = "Company";
    private static DisplayBadgeUiBinder uiBinder = (DisplayBadgeUiBinder)GWT.create(DisplayBadgeUiBinder.class);
    public static final String avatar_default = GWT.getModuleBaseURL() + "../images/Avatar_default.png";
    public static final String loading = GWT.getModuleBaseURL() + "../images/avatarLoader.gif";
    @UiField
    HTMLPanel mainPanel;
    @UiField
    Image avatarImage;
    @UiField
    HTML userFullName;
    @UiField
    HTML headlineLabel;
    @UiField
    HTML institutionLabel;
    @UiField
    AnchorElement imageRedirect;
    private BelongingUser myUserInfo;

    public DisplayBadge(BelongingUser user) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.avatarImage.setUrl(loading);
        this.mainPanel.addStyleName("profile-section");
        this.myUserInfo = user;
        this.avatarImage.getElement().getParentElement().setAttribute("href", this.myUserInfo.getAvatarId());
        this.avatarImage.setUrl(this.myUserInfo.getAvatarId());
        this.userFullName.setHTML("<a class=\"person-link\" href=\"" + user.getProfileLink() + "\">" + this.myUserInfo.getFullName() + "</a>");
        String head = user.getHeadline() == null || user.getHeadline().compareTo("") == 0 ? "" : user.getHeadline();
        String isti = user.getInstitution() == null || user.getInstitution().compareTo("") == 0 ? "" : user.getInstitution();
        this.headlineLabel.setText(head);
        this.institutionLabel.setText(isti);
        this.imageRedirect.setHref(user.getProfileLink());
        String title = "See profile of " + this.myUserInfo.getFullName();
        this.avatarImage.setTitle(title);
        this.userFullName.setTitle(title);
    }

    public void showError(String message) {
        Window.alert((String)("Failure: " + message));
        this.avatarImage.setSize("100px", "100px");
        this.avatarImage.setUrl(avatar_default);
    }
}

