/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.management;

import java.util.List;

import org.apache.log4j.Logger;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class ISUtil {
	
	protected static Logger logger = Logger.getLogger(ISUtil.class);
	protected static final String MAVEN_RR_NAME = "MavenRepository";
	protected static final String MAVEN_RR_ENTRYPOINT_NAME = "RepositoryUrl";
	
	public static AccessPoint getMavenAccessPoint(GCUBEScope scope) throws Exception
	{
		GCUBERuntimeResource runtimeResource = getRuntimeResource(scope, MAVEN_RR_NAME);
		AccessPoint accessPoint = getAccessPoint(runtimeResource, MAVEN_RR_ENTRYPOINT_NAME);
		return accessPoint;
	}
	
	public static AccessPoint getAccessPoint(GCUBERuntimeResource runtimeResource, String entryName) throws Exception
	{
		AccessPoint foundAccessPoint = null;
		for (AccessPoint accessPoint:runtimeResource.getAccessPoints()){
			if (accessPoint.getEntryname().equalsIgnoreCase(entryName)) {
				foundAccessPoint = accessPoint;
				break;
			}
		}

		if (foundAccessPoint==null) {
			logger.error("AccessPoint with entry name "+entryName+" not found for the Runtime Resource with name "+runtimeResource.getName()+", id "+runtimeResource.getID()+" and scopes "+runtimeResource.getScopes());
			throw new Exception("AccessPoint with entry name "+entryName+" not found for the Runtime Resource with name "+runtimeResource.getName()+", id "+runtimeResource.getID()+" and scopes "+runtimeResource.getScopes());
		}
		
		return foundAccessPoint;
	}	
	
	public static GCUBERuntimeResource getRuntimeResource(GCUBEScope scope, String runtimeResourceName) throws Exception
	{
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERuntimeResourceQuery query = client.getQuery(GCUBERuntimeResourceQuery.class);
		query.addAtomicConditions(new AtomicCondition("/Profile/Name",runtimeResourceName));
		List<GCUBERuntimeResource> resources = client.execute(query, scope);

		if (resources.size()==0) {
			logger.error("There is no Runtime Resource with name "+runtimeResourceName+" in scope "+scope);
			throw new Exception("There is no Runtime Resource with name "+runtimeResourceName+" in scope "+scope);
		}

		GCUBERuntimeResource resource = resources.get(0);
		return resource;
	}


}
