package org.gcube.portlets.widgets.fileupload.client;

import org.gcube.portlets.widgets.fileupload.client.events.FileUploadCompleteEvent;
import org.gcube.portlets.widgets.fileupload.client.events.FileUploadCompleteEventHandler;
import org.gcube.portlets.widgets.fileupload.client.view.UploadProgressDialog;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Timer;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class FileUpload implements EntryPoint {

	

	@Override
	public void onModuleLoad() {
		showSample();
	}
	
	private void showSample() {
		HandlerManager eventBus = new HandlerManager(null);
		
		final UploadProgressDialog dlg = new UploadProgressDialog("Share File",  eventBus);
		dlg.center();
		dlg.show();
		
		/**
		 * get the uploaded file result
		 */
		eventBus.addHandler(FileUploadCompleteEvent.TYPE, new FileUploadCompleteEventHandler() {
			
			@Override
			public void onUploadComplete(FileUploadCompleteEvent event) {
				
				//the filename and its path on server are returned to the client
				String fileName = event.getUploadedFileInfo().getFilename();
				String absolutePathOnServer = event.getUploadedFileInfo().getAbsolutePath();
				GWT.log(fileName + " uploaded on Server here: " + absolutePathOnServer);
				//pretend you do sth with the uploaded file, wait 3 seconds
				Timer t = new Timer() {
					
					@Override
					public void run() {
						dlg.showRegisteringResult(true); //or false if an error occurred						
					}
				};
				t.schedule(3000);
			}
		});
	}
}
