package org.gcube.portlets.widgets.fileupload.client.view;

import org.gcube.portlets.widgets.fileupload.client.controller.ProgressController;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.FormPanel.SubmitCompleteEvent;
import com.google.gwt.user.client.ui.FormPanel.SubmitCompleteHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 *
 */
public final class FileSubmit extends Composite {
	/**
	 * VERY IMPORTANT, must be the same in web.xml
	 */
	private static final String URL = "FileUpload/upload";
	
	private static final String LOADING_IMAGE = GWT.getModuleBaseURL() + "../images/spinning.gif";
	private static final String RESULT_OK = GWT.getModuleBaseURL() + "../images/ok.png";
	private static final String RESULT_NOK = GWT.getModuleBaseURL() + "../images/error.png";
	
	private HTML registeringLabel = new HTML("<span style=\"font-size: 15px; height: 20px; padding-top: 10px; display:inline-block; vertical-align:middle: 5px;\">"
			+ "Applying required operations, please wait ... </span><img style=\"margin: 0; padding-left: 10px; vertical-align: middle; \" src='" + LOADING_IMAGE + "'>");

	private FileUpload fileUpload;
	private FormPanel form;
	private Panel uploadPanel = new SimplePanel();
	private UploadProgressDialog dlg;
	
	public FileSubmit(UploadProgressDialog dlg, HandlerManager eventBus) {
		ProgressController.INSTANCE.initialize(eventBus);
		this.dlg = dlg;
		fileUpload = new FileUpload();
		fileUpload.setName("fileUpload");
		fileUpload.setTitle("select a file to upload");


		uploadPanel.setStyleName("FileSubmit");
		uploadPanel.add(fileUpload);


		form = new FormPanel();
		form.setEncoding(FormPanel.ENCODING_MULTIPART);
		form.setMethod(FormPanel.METHOD_POST);
		form.setAction(URL);
		form.setWidget(uploadPanel);

		this.initWidget(form);

		form.addSubmitCompleteHandler(new FormSubmitCompleteHandler());

		fileUpload.addChangeHandler(new ChangeHandler() {		
			@Override
			public void onChange(ChangeEvent event) {
				//fileUpload.setVisible(false);
				form.submit();				
			}
		});
	}

	protected void showRegisteringResult(boolean success) {
		uploadPanel.remove(registeringLabel);
		if (success)
			uploadPanel.add( new HTML("<span style=\"font-size: 15px; height: 20px; padding-top: 10px; display:inline-block; vertical-align:middle : 5px;\">"
					+ "Operation Completed Successfully </span><img style=\"margin: 0; padding-left: 10px; vertical-align: middle; \" src='" + RESULT_OK + "'>"));
		else
			uploadPanel.add( new HTML("<span style=\"font-size: 15px; height: 20px; padding-top: 10px; display:inline-block; vertical-align:middle : 5px;\">"
					+ "Sorry, an error occurred in the Server</span><img style=\"margin: 0; padding-left: 10px; vertical-align: middle; \" src='" + RESULT_NOK + "'>"));
		dlg.showFinalCloseButton();
	}
	
	
	
	private class FormSubmitCompleteHandler implements SubmitCompleteHandler {

		@Override
		public void onSubmitComplete(final SubmitCompleteEvent event) {
			//form.reset();
			uploadPanel.remove(fileUpload);
			uploadPanel.add(registeringLabel);
			dlg.hideCloseButton();
		}
	} 
	

}
