/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.widgets.fileupload.server;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.ProgressListener;

public final class UploadProgressInputStream
extends FilterInputStream {
    private List<ProgressListener> listeners;
    private long bytesRead = 0L;
    private long totalBytes = 0L;

    public UploadProgressInputStream(InputStream in, long totalBytes) {
        super(in);
        this.totalBytes = totalBytes;
        this.listeners = new ArrayList();
    }

    public void addListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        ++this.bytesRead;
        this.updateListeners(this.bytesRead, this.totalBytes);
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        this.bytesRead += (long)bytesRead;
        this.updateListeners(this.bytesRead, this.totalBytes);
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.updateListeners(this.totalBytes, this.totalBytes);
    }

    private void updateListeners(long bytesRead, long totalBytes) {
        for (ProgressListener listener : this.listeners) {
            listener.update(bytesRead, totalBytes, this.listeners.size());
        }
    }
}

