package org.gcube.datacatalogue.grsf_manage_widget.shared;

import java.io.Serializable;


/**
 * A similar grsf record.
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 */
public class SimilarGRSFRecord implements Serializable{

	private static final long serialVersionUID = 6501670015333073045L;
	private String description; 
	private String knowledgeBaseId;
	private String semanticIdentifier;
	private String shortName;
	private String url;
	private boolean suggestedMerge;
	private boolean isExtra;
	private boolean toBeKept = true;

	public SimilarGRSFRecord() {
		super();
	}

	/**
	 * @param description
	 * @param knowledgeBaseId
	 * @param semanticIdentifier
	 * @param shortName
	 * @param url
	 * @param suggestedMerge
	 * @param isExtra
	 * @param toBeKept
	 */
	public SimilarGRSFRecord(String description, String knowledgeBaseId,
			String semanticIdentifier, String shortName, String url) {
		super();
		this.description = description;
		this.knowledgeBaseId = knowledgeBaseId;
		this.semanticIdentifier = semanticIdentifier;
		this.shortName = shortName;
		this.url = url;
	}
	public String getKnowledgeBaseId() {
		return knowledgeBaseId;
	}


	public void setKnowledgeBaseId(String knowledgeBaseId) {
		this.knowledgeBaseId = knowledgeBaseId;
	}


	public String getSemanticIdentifier() {
		return semanticIdentifier;
	}


	public void setSemanticIdentifier(String semanticIdentifier) {
		this.semanticIdentifier = semanticIdentifier;
	}


	public void setToBeKept(boolean toBeKept) {
		this.toBeKept = toBeKept;
	}

	public boolean isToBeKept() {
		return toBeKept;
	}

	public String getShortName() {
		return shortName;
	}
	public void setShortName(String shortName) {
		this.shortName = shortName;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public boolean isSuggestedMerge() {
		return suggestedMerge;
	}

	public void setSuggestedMerge(boolean suggestedMerge) {
		this.suggestedMerge = suggestedMerge;
	}

	public boolean isExtra() {
		return isExtra;
	}

	public void setExtra(boolean isExtra) {
		this.isExtra = isExtra;
	}
	@Override
	public String toString() {
		return "SimilarGRSFRecord [description=" + description
				+ ", knowledgeBaseId=" + knowledgeBaseId
				+ ", semanticIdentifier=" + semanticIdentifier + ", shortName="
				+ shortName + ", url=" + url + ", suggestedMerge="
				+ suggestedMerge + ", isExtra=" + isExtra + ", toBeKept="
				+ toBeKept + "]";
	}

}
