package org.gcube.portlets.widgets.guidedtour.server;

import java.util.List;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.widgets.guidedtour.client.TourService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoTableConstants;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class TourServiceImpl extends RemoteServiceServlet implements TourService {

	private static final Logger _log = LoggerFactory.getLogger(TourServiceImpl.class);

	private static final String QUICK_TOUR_PREFIX = "QT";
	public boolean withinPortal = false;
	/**
	 * the current ASLSession
	 * @return the session
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		if (user == null) {
			user = "test.user";
		}
		else {
			withinPortal = true;
		}
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	/**
	 * check if a custom attribute with name portlet name exists
	 */
	@Override
	public Boolean showTour(String portletUniqueId) {
		String username = getASLSession().getUsername();
		String attrToCheck = getUniqueIdentifier(username, portletUniqueId);
		_log.info("Checking custom attribute via ExpandoBridge " + attrToCheck);
		try {
			if ( ! withinPortal) return true;//if running into eclipse always shows the popup	
	
			User currUser = OrganizationsUtil.validateUser(username);

			boolean toReturn =  (ExpandoValueLocalServiceUtil.getValue(
					OrganizationsUtil.getCompany().getCompanyId(), 
					User.class.getName(),  
					ExpandoTableConstants.DEFAULT_TABLE_NAME, attrToCheck, currUser.getUserId()) == null);

			//boolean toReturn =  (currUser.getExpandoBridge().getAttribute(attrToCheck) == null);
			
			_log.info("Checked custom attribute result via ExpandoBridge: showTour? " + toReturn);
			return toReturn;
		} catch (Exception e) {
			e.printStackTrace();
			return true;
		} 
	}
	@Override
	public void setNotShowItAgain(String portletUniqueId) {
		String username = getASLSession().getUsername();
		String attrToSet = getUniqueIdentifier(username, portletUniqueId);
		if ( ! withinPortal) return;//if running into eclipse always return
		User currUser = null;
		try {
			currUser = OrganizationsUtil.validateUser(username);
			Role adminRole = RoleLocalServiceUtil.getRole(OrganizationsUtil.getCompany().getCompanyId(),"Administrator");
			List<User> adminUsers = UserLocalServiceUtil.getRoleUsers(adminRole.getRoleId());

			PrincipalThreadLocal.setName(adminUsers.get(0).getUserId());
			PermissionChecker permissionChecker =PermissionCheckerFactoryUtil.create(adminUsers.get(0), true);
			PermissionThreadLocal.setPermissionChecker(permissionChecker);
			
			_log.trace("Creating and Setting custom attribute for colName " + attrToSet + " to " + "NOT_AGAIN");
			currUser.getExpandoBridge().addAttribute(attrToSet);
			currUser.getExpandoBridge().setAttribute(attrToSet, "NOT_AGAIN");
		}
		catch (Exception e) {
			e.printStackTrace();
		} 

	}
	/**
	 * need to trunc to 75 char as declared in the schema ( type character varying(75))
	 * @param username
	 * @param portletid
	 * @return
	 */
	public static String getUniqueIdentifier(String username, String portletid) {
		String toReturn = username+QUICK_TOUR_PREFIX+portletid;
		if (toReturn.length() > 74)
			return (username+QUICK_TOUR_PREFIX+portletid).substring(0, 74);
		else
			return toReturn;
	}
}