package org.gcube.portlets.widgets.sessionchecker.server;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.gcube.common.portal.ContextUserUtil;
import org.gcube.common.portal.PortalContext;
import org.gcube.portlets.widgets.sessionchecker.client.SessionCheckerService;
import org.gcube.portlets.widgets.sessionchecker.shared.SessionInfoBean;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.service.UserLocalServiceUtil;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class SessionCheckerServiceImpl extends RemoteServiceServlet implements  SessionCheckerService {

	private static final Logger _log = LoggerFactory.getLogger(SessionCheckerServiceImpl.class);
	public static final String USER_ID_ATTR_NAME = "gcube-userId";


	@Override
	public SessionInfoBean checkSession() {
		if (isWithinPortal()) {
			HttpServletRequest request = getThreadLocalRequest();
			System.out.println("*** \n\nHTTP Session id = " + request.getSession().getId());
			if (checkUserLogged(request)) {
				String user = PortalContext.getConfiguration().getCurrentUser(getThreadLocalRequest()).getUsername();
				String scope = PortalContext.getConfiguration().getCurrentScope(getThreadLocalRequest());
				_log.trace("Session check OK for " + user + " at " + new Date());
				return new SessionInfoBean(user, scope);
			}
			else {
				System.out.println("***User Session expired = ");
				return new SessionInfoBean(null, null);
			}
			
		} else {
			_log.warn("Stopping session polling as i think you are in development mode");
			return new SessionInfoBean("","", true); //tells that you are in development mode 				
		}
	}
	private boolean checkUserLogged(HttpServletRequest httpServletRequest) {
		String userIdNo = httpServletRequest.getHeader(USER_ID_ATTR_NAME);
		System.out.println("*** checkUserLogged =" + userIdNo);
		return (userIdNo != null);
	}
	/**
	 * 
	 * @return true if you're running into the portal, false if in development
	 */
	private boolean isWithinPortal() {
		try {
			UserLocalServiceUtil.getService();
			return true;
		} 
		catch (com.liferay.portal.kernel.bean.BeanLocatorException ex) {			
			_log.trace("Development Mode ON");
			return false;
		}			
	}
}
