/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.widgets.wsthreddssync;

import org.gcube.usecases.ws.thredds.SyncEngine;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessDescriptor;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessStatus;
import org.gcube.usecases.ws.thredds.faults.WorkspaceLockedException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceNotSynchedException;
import org.gcube.usecases.ws.thredds.model.SyncOperationCallBack;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;

public class TestWsThreddsEngine {
    public static String DEFAULT_SCOPE = "/gcube/devsec";
    public static String TEST_USER = "francesco.mangiacrapa";
    public static String TEST_FOLDER_ID = "";

    public static void main(String[] args) throws Exception {
        SyncEngine engine = SyncEngine.get();
        String filter = "";
        String remotePersistence = "";
        String remotePath = "";
        String targetToken = "";
        SynchFolderConfiguration config = new SynchFolderConfiguration(remotePath, filter, targetToken, remotePersistence, TEST_FOLDER_ID);
        try {
            System.out.println("Cleaning it up..");
            engine.unsetSynchronizedFolder(TEST_FOLDER_ID, false);
        }
        catch (WorkspaceNotSynchedException workspaceNotSynchedException) {
        }
        catch (WorkspaceLockedException e) {
            engine.forceUnlock(TEST_FOLDER_ID);
            engine.unsetSynchronizedFolder(TEST_FOLDER_ID, false);
        }
        try {
            engine.check(TEST_FOLDER_ID, false);
        }
        catch (WorkspaceNotSynchedException e) {
            System.out.println("Folder not synched, configurin it..");
            engine.setSynchronizedFolder(config, TEST_FOLDER_ID);
        }
        catch (WorkspaceLockedException e) {
            System.out.println("Workspace locked, going to force unlock..");
            engine.forceUnlock(TEST_FOLDER_ID);
        }
        ProcessDescriptor descriptor = engine.doSync(TEST_FOLDER_ID);
        System.out.println("Obtained descriptor : " + descriptor);
        SyncOperationCallBack syncCall = new SyncOperationCallBack(){

            public void onStep(ProcessStatus status, ProcessDescriptor descriptor) {
                System.out.println("ON STEP : " + status + " " + descriptor);
                System.out.println("LOG : \n" + status.getLogBuilder().toString());
                if (status.getStatus().equals((Object)ProcessStatus.Status.COMPLETED)) {
                    // empty if block
                }
            }
        };
        engine.registerCallBack(TEST_FOLDER_ID, syncCall);
        engine.check(TEST_FOLDER_ID, true);
        engine.shutDown();
    }
}

