package org.gcube.portlets.widgets.wsmail.server;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.widgets.wsmail.client.WsMailService;
import org.gcube.portlets.widgets.wsmail.shared.CurrUserAndPortalUsersWrapper;
import org.gcube.portlets.widgets.wsmail.shared.WSUser;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class WsMailServiceImpl extends RemoteServiceServlet implements WsMailService {

	private static final Logger _log = LoggerFactory.getLogger(WsMailServiceImpl.class);
	public static final String TEST_SCOPE = "/gcube/devsec";
	public static final String TEST_USER = "test.user";
	public static final String USERNAME_ATTRIBUTE = "username";
	private boolean withinPortal = false;
	/**
	 * the current ASLSession
	 * @return the session
	 */
	private ASLSession getASLSession() {		
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		String sessionID = httpSession.getId();
		String user = (String) httpSession.getAttribute("username");
		if (user == null) {
			_log.warn("TEST MODE - NO USER FOUND");
			ASLSession session = SessionManager.getInstance().getASLSession(sessionID, getDevelopmentUser());
			session.setScope(TEST_SCOPE);

			return session;
		}
		else {
			_log.info("LIFERAY PORTAL DETECTED user=" + user);
			withinPortal = true;
		}
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	/**
	 * when packaging test will fail if the user is not set to test.user
	 * @return .
	 */
	public String getDevelopmentUser() {
		String user = TEST_USER;
		//user = "massimiliano.assante";
		return user;
	}
	/**
	 * 
	 * @return the list of workspace users
	 */
	public CurrUserAndPortalUsersWrapper getWorkspaceUsers() {
		ASLSession session = getASLSession();
		_log.info("trying to get WorkspaceUserss .. withinPortal="+withinPortal);
		WSUser currUser = null;
		ArrayList<WSUser> portalUsers = new ArrayList<WSUser>();
		try {
			if (withinPortal) {
				UserManager um = new LiferayUserManager();
				GroupManager gm = new LiferayGroupManager();
				List<UserModel> users = um.listUsersByGroup(gm.getRootVO().getGroupId());
				for (UserModel user : users) {
					_log.trace("Trying to get additional info for "+user.getScreenName());
					if (user.getScreenName().compareTo("test.user") != 0) { //skip test.user
						portalUsers.add(new WSUser(user.getUserId(), user.getScreenName(), user.getFullname(), user.getEmail()));
					}
				}
				currUser = new WSUser(session.getUsername(), session.getUsername(), session.getUserFullName(), session.getUserEmailAddress());
			}
			else { //test users
				portalUsers.add(new WSUser("11111", "massimiliano.assante", "Massimiliano Assante", "assante@isti.cnr.it"));
				portalUsers.add(new WSUser("11111", "giogio.giorgi", "Giorgio Giorgietti", "pippo@aol.com"));
				portalUsers.add(new WSUser("2222", "pino.pinetti", "Pino Dall'ara", "ambaradam@aol.com"));
				portalUsers.add(new WSUser("11333111", "rino.gattuso", "Rino Gattuso", "rino@acmilan.com"));
				portalUsers.add(new WSUser("114444111", "alex.delpiero", "Alessandro Del Piero", "delpiero@juventus.com"));
				portalUsers.add(new WSUser("3462", "sandro.nesta", "Alessandro Nesta", "sandro@montreal.it"));
				portalUsers.add(new WSUser("11464321", "samsung.mobile", "Samsung Mobile", "samsung@samsung.com"));	
				
				currUser = new WSUser("12345", "francesco.mangiacrapa", "Francesco Mangiacrapa", "assante@isti.cnr.it");
			}
		} catch (Exception e) {
			_log.error("Error in server get all contacts ", e);
		}
		//		for (WSUser user : toReturn) {
		//			_log.trace("Got: "+user.toString());
		//		}
		
		CurrUserAndPortalUsersWrapper toReturn = new CurrUserAndPortalUsersWrapper(currUser, portalUsers);
		return toReturn;
	}
	/**
	 * 
	 */
	@Override
	public boolean sendToById(ArrayList<String> listContactsId,	ArrayList<String> listAttachmentsId, String subject, String body) {
		String checkedSubject = escapeHtml(subject);
		String checkedBody = escapeHtml(body);
		if (listAttachmentsId == null)
			listAttachmentsId = new ArrayList<String>();
		try {
			Workspace workspace = getWorkspace();
			_log.info("Sending messageTextArea to: " + listContactsId.toString());

			workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(checkedSubject, checkedBody, listAttachmentsId, listContactsId);


			NotificationsManager nnm = new ApplicationNotificationsManager(getASLSession());
			for (String userIdToNotify : listContactsId) {
				if (nnm.notifyMessageReceived(userIdToNotify, checkedSubject))
					_log.trace("Sending notifications to: " + userIdToNotify + " OK");
			}
			return true;
		} catch (Exception e) {
			_log.error("While Sending messageTextArea to: " + listContactsId.toString());
			e.printStackTrace();
			return false;
		}
	}
	/**
	 * 
	 * @return the workspace instance
	 * @throws InternalErrorException
	 * @throws HomeNotFoundException
	 * @throws WorkspaceFolderNotFoundException
	 */
	private Workspace getWorkspace() throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
		final ASLSession session = getASLSession();
		Workspace workspace = HomeLibrary.getUserWorkspace(session.getUsername());
		return workspace;
	}
	/**
	 * Escape an html string. Escaping data received from the client helps to
	 * prevent cross-site script vulnerabilities.
	 * 
	 * @param html the html string to escape
	 * @return the escaped string
	 */
	private String escapeHtml(String html) {
		if (html == null) {
			return null;
		}
		return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;")
				.replaceAll(">", "&gt;");
	}


}
