/**
 *
 */
package org.gcube.portlets.widgtes.wsthreddssync.shared;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;




// TODO: Auto-generated Javadoc
/**
 * The Class TransferToThreddsProperty.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Feb 7, 2018
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class TransferToThreddsProperty implements Serializable{


	/** The folder id. */
	private String folderId;
	
	/** The catalogue name. */
	private String catalogueName;
	
	/** The vre name. */
	private String vreName;
	
	/** The vre scope. */
	private String vreScope;
	
	/** The metadata folder id. */
	private String metadataFolderId;
	
	/** The metadata folder name. */
	private String metadataFolderName;


	/**
	 * Instantiates a new transfering to thredds property.
	 */
	public TransferToThreddsProperty() {

	}

	/**
	 * Instantiates a new transfering to thredds property.
	 *
	 * @param folderId the folder id
	 * @param catalogueName the catalogue name
	 * @param vreName the vre name
	 * @param vreScope the vre scope
	 * @param metadataFolderId the metadata folder id
	 * @param metadataFolderName the metadata folder name
	 */
	public TransferToThreddsProperty(
		String folderId, String catalogueName, String vreName,
		String vreScope, String metadataFolderId, String metadataFolderName) {

		super();
		this.folderId = folderId;
		this.catalogueName = catalogueName;
		this.vreName = vreName;
		this.vreScope = vreScope;
		this.metadataFolderId = metadataFolderId;
		this.metadataFolderName = metadataFolderName;
	}


	/**
	 * Gets the folder id.
	 *
	 * @return the folderId
	 */
	public String getFolderId() {

		return folderId;
	}


	/**
	 * Gets the catalogue name.
	 *
	 * @return the catalogueName
	 */
	public String getCatalogueName() {

		return catalogueName;
	}


	/**
	 * Gets the vre name.
	 *
	 * @return the vreName
	 */
	public String getVreName() {

		return vreName;
	}


	/**
	 * Gets the vre scope.
	 *
	 * @return the vreScope
	 */
	public String getVreScope() {

		return vreScope;
	}


	/**
	 * Gets the metadata folder id.
	 *
	 * @return the metadataFolderId
	 */
	public String getMetadataFolderId() {

		return metadataFolderId;
	}


	/**
	 * Gets the metadata folder name.
	 *
	 * @return the metadataFolderName
	 */
	public String getMetadataFolderName() {

		return metadataFolderName;
	}


	/**
	 * Sets the folder id.
	 *
	 * @param folderId the folderId to set
	 */
	public void setFolderId(String folderId) {

		this.folderId = folderId;
	}


	/**
	 * Sets the catalogue name.
	 *
	 * @param catalogueName the catalogueName to set
	 */
	public void setCatalogueName(String catalogueName) {

		this.catalogueName = catalogueName;
	}


	/**
	 * Sets the vre name.
	 *
	 * @param vreName the vreName to set
	 */
	public void setVreName(String vreName) {

		this.vreName = vreName;
	}


	/**
	 * Sets the vre scope.
	 *
	 * @param vreScope the vreScope to set
	 */
	public void setVreScope(String vreScope) {

		this.vreScope = vreScope;
	}


	/**
	 * Sets the metadata folder id.
	 *
	 * @param metadataFolderId the metadataFolderId to set
	 */
	public void setMetadataFolderId(String metadataFolderId) {

		this.metadataFolderId = metadataFolderId;
	}


	/**
	 * Sets the metadata folder name.
	 *
	 * @param metadataFolderName the metadataFolderName to set
	 */
	public void setMetadataFolderName(String metadataFolderName) {

		this.metadataFolderName = metadataFolderName;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {

		StringBuilder builder = new StringBuilder();
		builder.append("TransferToThreddsProperty [folderId=");
		builder.append(folderId);
		builder.append(", catalogueName=");
		builder.append(catalogueName);
		builder.append(", vreName=");
		builder.append(vreName);
		builder.append(", vreScope=");
		builder.append(vreScope);
		builder.append(", metadataFolderId=");
		builder.append(metadataFolderId);
		builder.append(", metadataFolderName=");
		builder.append(metadataFolderName);
		builder.append("]");
		return builder.toString();
	}


}
