package org.gcube.portlets.widgtes.wsthreddssync.server;

import org.gcube.portal.wssynclibrary.shared.thredds.Sync_Status;
import org.gcube.portal.wssynclibrary.shared.thredds.ThSyncFolderDescriptor;
import org.gcube.portal.wssynclibrary.shared.thredds.ThSynchFolderConfiguration;
import org.gcube.portlets.widgtes.wsthreddssync.shared.GcubeVRE;
import org.gcube.portlets.widgtes.wsthreddssync.shared.WsThreddsSynchFolderConfiguration;
import org.gcube.portlets.widgtes.wsthreddssync.shared.WsThreddsSynchFolderDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static org.gcube.common.authorization.client.Constants.authorizationService;

import org.gcube.common.authorization.library.AuthorizationEntry;


// TODO: Auto-generated Javadoc
/**
 * The Class BeanConverter.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Feb 16, 2018
 */
public class BeanConverter {
	
	private static Logger logger = LoggerFactory.getLogger(BeanConverter.class);
	
	/**
	 * To ws thredds folder config.
	 *
	 * @param t the t
	 * @param theStatus the the status
	 * @return the ws thredds synch folder descriptor
	 */
	public static WsThreddsSynchFolderDescriptor toWsThreddsFolderConfig(ThSyncFolderDescriptor t, Sync_Status theStatus) {
		
		if(t==null)
			return null;
		
		WsThreddsSynchFolderDescriptor ws = new WsThreddsSynchFolderDescriptor();
		ws.setServerFolderDescriptor(t);
		ws.setSyncStatus(theStatus);
		
		//FROM TARGET TOKEN TO SCOPE 
		//t.getConfiguration().getTargetToken()
		
		if(t.getConfiguration().getTargetToken()!=null) {
			try {
				AuthorizationEntry entry = authorizationService().get(t.getConfiguration().getTargetToken());
				String scope = entry.getContext();
				GcubeVRE selectedVRE = new GcubeVRE(scope, scope);
				ws.setSelectedVRE(selectedVRE);
				logger.debug("Resolved VRE: "+selectedVRE +" from token");
			}catch (Exception e) {
				// TODO: handle exception
			}
		}
		
		

		return ws;
		
	};

	/**
	 * To th synch folder configuration.
	 *
	 * @param t the t
	 * @param targetScopeUserToken the target scope user token
	 * @return the th synch folder configuration
	 */
	public static ThSynchFolderConfiguration toThSynchFolderConfiguration(WsThreddsSynchFolderConfiguration t, String targetScopeUserToken) {
		
		if(t==null)
			return null;
		
		ThSynchFolderConfiguration ts = new ThSynchFolderConfiguration();
		ts.setFilter(t.getFilter());
		ts.setRemotePath(t.getRemotePath());
		ts.setTargetToken(targetScopeUserToken);
		ts.setToCreateCatalogName(t.getCatalogName());
		return ts;
		
	};

}
