package org.gcube.portlets.widgtes.wsthreddssync.shared;

import java.io.Serializable;

import org.gcube.portal.wssynclibrary.shared.thredds.Status;


// TODO: Auto-generated Javadoc
/**
 * The Class WsThreddsSynchFolderConfiguration.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Feb 16, 2018
 */
public class WsThreddsSynchFolderConfiguration implements Serializable{
	

	/**
	 * 
	 */
	private static final long serialVersionUID = -1140248888970305126L;

	/** The remote path. */
	private String remotePath;
	
	private GcubeVRE theSelectedVRE;

	/** The filter. */
	private String filter;

	/** The to create catalog name. */
	private String catalogName;
	
	private Status status; //just for serialization
	
	
	/**
	 * Instantiates a new ws thredds synch folder configuration.
	 */
	public WsThreddsSynchFolderConfiguration() {
		// TODO Auto-generated constructor stub
	}
	
	
	/**
	 * Instantiates a new ws thredds synch folder configuration.
	 *
	 * @param remotePath the remote path
	 * @param theVRE the the VRE
	 * @param filter the filter
	 * @param catalogName the catalog name
	 * @param serverConf the server conf
	 */
	public WsThreddsSynchFolderConfiguration(String remotePath, GcubeVRE theVRE, String filter, String catalogName) {
		super();
		this.remotePath = remotePath;
		this.theSelectedVRE = theVRE;
		this.filter = filter;
		this.catalogName = catalogName;
	}

	/**
	 * Gets the remote path.
	 *
	 * @return the remote path
	 */
	public String getRemotePath() {
		return remotePath;
	}

	/**
	 * Sets the remote path.
	 *
	 * @param remotePath the new remote path
	 */
	public void setRemotePath(String remotePath) {
		this.remotePath = remotePath;
	}

	/**
	 * Gets the the VRE.
	 *
	 * @return the the VRE
	 */
	public GcubeVRE getTheVRE() {
		return theSelectedVRE;
	}

	/**
	 * Sets the the VRE.
	 *
	 * @param theVRE the new the VRE
	 */
	public void setTheVRE(GcubeVRE theVRE) {
		this.theSelectedVRE = theVRE;
	}

	/**
	 * Gets the filter.
	 *
	 * @return the filter
	 */
	public String getFilter() {
		return filter;
	}

	/**
	 * Sets the filter.
	 *
	 * @param filter the new filter
	 */
	public void setFilter(String filter) {
		this.filter = filter;
	}

	/**
	 * Gets the catalog name.
	 *
	 * @return the catalog name
	 */
	public String getCatalogName() {
		return catalogName;
	}

	/**
	 * Sets the catalog name.
	 *
	 * @param catalogName the new catalog name
	 */
	public void setCatalogName(String catalogName) {
		this.catalogName = catalogName;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("WsThreddsSynchFolderDescriptor [remotePath=");
		builder.append(remotePath);
		builder.append(", theSelectedVRE=");
		builder.append(theSelectedVRE);
		builder.append(", filter=");
		builder.append(filter);
		builder.append(", catalogName=");
		builder.append(catalogName);
		builder.append("]");
		return builder.toString();
	}
}
