package org.gcube.portlets.widgtes.wsthreddssync.client.rpc;

import java.util.List;

import org.gcube.portal.wssynclibrary.shared.thredds.ThSyncStatus;
import org.gcube.portlets.widgtes.wsthreddssync.shared.GcubeVRE;
import org.gcube.portlets.widgtes.wsthreddssync.shared.WsThreddsSynchFolderConfiguration;
import org.gcube.portlets.widgtes.wsthreddssync.shared.WsThreddsSynchFolderDescriptor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface ThreddsWorkspaceSyncServiceAsync
{

    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static ThreddsWorkspaceSyncServiceAsync instance;

        public static final ThreddsWorkspaceSyncServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (ThreddsWorkspaceSyncServiceAsync) GWT.create( ThreddsWorkspaceSyncService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instantiated
        }
    }


	void isItemSynched(String folderId, AsyncCallback<WsThreddsSynchFolderDescriptor> callback);


	void doSyncFolder(String folderId, WsThreddsSynchFolderConfiguration clientConfig, AsyncCallback<ThSyncStatus> callback);


	void monitorSyncStatus(String folderId, AsyncCallback<ThSyncStatus> callback);


	void getListOfVREsForLoggedUser(AsyncCallback<List<GcubeVRE>> callback);
}
