package org.gcube.portlets.user.gisviewer.client.layerspanel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.gcube.portlets.user.gisviewer.client.Constants;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.commons.utils.ODLListBox;

import com.extjs.gxt.ui.client.data.BaseTreeModel;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.SliderEvent;
import com.extjs.gxt.ui.client.event.TreePanelEvent;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Slider;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel.CheckCascade;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel.CheckNodes;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/*
 * singleton, implementa il tree panel dei layers
 */
@SuppressWarnings("deprecation")
public class GxtGeoTreePanel {
	// private PopupPanel menuOLD;
	// private VerticalPanel menuItems;
	
	private LayersPanelHandler treeHandler;

	@SuppressWarnings("unused")
	private String cxNode_layer;
	@SuppressWarnings("unused")
	private String cxNode_legend;
	private BaseTreeModel cxNode = null;
	private TreeStore<ModelData> store;
	private TreePanel<ModelData> tree;

	private Button btFilter;
	private Button btNoFilter;
	private Button btSave;
	private Button btOpen;
	private Button btTransect;
	
	private PopupPanel menu;
	private VerticalPanel menuItems;
	private Slider slider;

	public GxtGeoTreePanel(LayersPanelHandler treeHandler, String projection) {
//		,
//	
//			SelectedLayersHandle iselectedLayers,
//			IOpacityLayers iopacityLayers,
//			ManageLegendHandle manageLegendHandle, IFilterLayers iFilterLayers,
//			SaveLayer saveLayer, MapTransect mapTransect) {
		
		this.treeHandler = treeHandler;

		menu = new PopupPanel(true);
		menu.addStyleName("z_index_1150");
		//GwtGeoExtPanel.disableContextMenu(this.simplePopup.getElement());
	    //simplePopup.ensureDebugId("cwBasicPopup-simplePopup");
	    menu.setWidth("270px");
	    menuItems = new VerticalPanel();
	    menuItems.setStyleName("bgGreyMedium");
	    menu.setWidget(menuItems);
	    
	    menu.addPopupListener(new PopupListener() {
			public void onPopupClosed(PopupPanel sender, boolean autoClosed) {				
				cxNode.set("opac", new Double((double)slider.getValue()/100));
				cxNode = null;
				cxNode_layer = "";
				cxNode_legend = "";
			}
		});
	}

	
	@SuppressWarnings("unchecked")
	private void showContextMenu(TreePanelEvent<ModelData> be) {
		if ((Boolean)be.getItem().get(("isFolderNode"))) 
			return;
		//if ((Boolean)be.getNode().getModel().get("isFolderNode"));

		
		menuItems.clear();
		cxNode = (BaseTreeModel) be.getItem();
		cxNode_layer = cxNode.get("layer");
		cxNode_legend = cxNode.get("legend");
		final boolean isBase = (Boolean) cxNode.get("base");
		final boolean hasLegend = (Boolean)(cxNode.get("hasLegend"));
		final int left = be.getClientX(), top = be.getClientY();
		
		// menuOLD.setPopupPosition(tree.getAbsoluteLeft() + 30,
		// 10);//e.getPageY());
		// menuOLD.show();

		// FILTER SECTION
		btFilter = new Button("Set Filter",
			new SelectionListener<ButtonEvent>() {
				@Override
				public void componentSelected(ButtonEvent ce) {					
					//treeHandler.showFilterQuery(cxNode_layer, left, top); 
					btNoFilter.setVisible(true);
					menu.hide();
				}
			});
		btFilter.addStyleName("geo-menu_button");
		btFilter.setWidth("100%");

		menuItems.add(btFilter);

		// NO FILTER SECTION
		btNoFilter = new Button("Remove Filter", new SelectionListener<ButtonEvent>() {
				@Override
				public void componentSelected(ButtonEvent ce) {
					//treeHandler.removeFilterQuery(cxNode_layer, left, top);
					btNoFilter.setVisible(false);
				}
			});
		btNoFilter.addStyleName("geo-menu_button");
		btNoFilter.setWidth("100%");
		btNoFilter.setVisible(false);

		menuItems.add(btNoFilter);

		// SAVE SECTION
		HorizontalPanel save_hp = new HorizontalPanel();

		final Map<String, String> items = new HashMap<String, String>();
		final Map<String, String> items_wfs = new HashMap<String, String>();

		items.put("AtomPub", "application/atom+xml");
		items.put("GIF", "image/gif");
		items.put("GeoRSS", "application/rss+xml");
		items.put("JPEG", "image/jpeg");
		items.put("KML (compressed)", "application/vnd.google-earth.kmz+xml");
		items.put("KML (plain)", "application/vnd.google-earth.kml+xml");
		items.put("PDF", "application/pdf");
		items.put("PNG", "image/png");
		items.put("SVG", "image/svg+xml");
		items.put("Tiff", "image/tiff");

		final ODLListBox save_list = new ODLListBox();
		save_list.setWidth("160px");
		save_list.addItem("Select one", "");
		save_list.addOptionsGroup("WMS", items);

		if (isBase) {
			items_wfs.put("CSV", "csv");
			items_wfs.put("GML2", "GML2");
			items_wfs.put("GML2-GZIP", "GML2-GZIP");
			items_wfs.put("GML3", "text/xml; subtype=gml/3.1.1");
			items_wfs.put("GeoJSON", "json");
			items_wfs.put("Shapefile", "SHAPE-ZIP");
			save_list.addOptionsGroup("WFS", items_wfs);
		}

		save_hp.add(save_list);
		//save_hp.setCellWidth(save_list, "160px");

//		btSave = new Button("Save", new SelectionListener<ButtonEvent>() {
//			@Override
//			public void componentSelected(ButtonEvent ce) {
//				if (!save_list.getValue(save_list.getSelectedIndex())
//						.contentEquals("")) {
//					treeHandler.saveLayer(cxNode_layer, cxNode_legend, save_list
//							.getValue(save_list.getSelectedIndex()), save_list
//							.getItemText(save_list.getSelectedIndex()),
//							(save_list.getGroup(save_list.getSelectedIndex())
//									.contentEquals("WMS")));
//					menu.hide();
//				}
//			}
//		});
//		btSave.setEnabled(Constants.isSaveButtonEnabled);

		btOpen = new Button("Open", new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				if (!save_list.getValue(save_list.getSelectedIndex())
						.contentEquals("")) {
					//BoundsMap maxExtent = (BoundsMap)cxNode.getAttributeAsObject("maxExtent");
					System.out.println(">>>>>>>>>> "
							+ save_list.getSelectedIndex());

					/*treeHandler.openLayer(cxNode_layer, cxNode_legend, save_list
							.getValue(save_list.getSelectedIndex()), save_list
							.getItemText(save_list.getSelectedIndex()),
							(save_list.getGroup(save_list.getSelectedIndex())
									.contentEquals("WMS")));*/
					menu.hide();
				} else
					Window.alert("No image type selected.");
			} 
		});

		// btSave.setStylePrimaryName("geo-menu_button");
		btSave.addStyleName("geo-menu_button");
		btSave.setWidth("100%");
		btOpen.addStyleName("geo-menu_button");
		btOpen.setWidth("100%");

		save_hp.add(btOpen);
		save_hp.add(btSave);

		save_hp.setWidth("100%");

		menuItems.add(save_hp);

		// LEGEND
		if (hasLegend) {
			HorizontalPanel legend_hp = new HorizontalPanel();
			final ODLListBox legend_list = new ODLListBox();

			legend_list.addChangeHandler(new ChangeHandler() {
				public void onChange(ChangeEvent event) {
					String value = legend_list.getValue(legend_list.getSelectedIndex());
					System.out.println("index: " + value);
					cxNode.set("legend", value);
					((LayerItem)cxNode.get("layerItem")).setStyle(value);//TODO CHECK
					//treeHandler.changeLegend(cxNode_layer, value);
				}
			});

			legend_list.addItem((String) cxNode.get("legend"),
					(String) cxNode.get("legend"));

			ArrayList<String> legends = (ArrayList<String>) cxNode.get("legends");

			for (String leg : legends) {
				if (!leg.contentEquals((String) cxNode.get("legend"))) {
					legend_list.addItem(leg, leg);
				}
			}

			legend_hp.add(legend_list);
			legend_hp.setWidth("100%");
			legend_list.setWidth("160px");

			Button btShowLegend = new Button("Show Legend",
					new SelectionListener<ButtonEvent>() {
						@Override
						public void componentSelected(ButtonEvent ce) {
							treeHandler.showLegend(null, left, top);
							//treeHandler.showLegend(cxNode_layer, left, top);
							menu.hide();
						}
					});
			btShowLegend.setWidth("100%");

			// bt.setStylePrimaryName("geo-menu_button");
			btShowLegend.addStyleName("geo-menu_button");
			legend_hp.add(btShowLegend);
			// legend_hp.setCellWidth(legend_list, "160px");
			menuItems.add(legend_hp);
		}

		// TRANSECT
		if (hasLegend && !((String) cxNode.get("fieldTransect")).contentEquals("")) {
			btTransect = new Button("Transect",
					new SelectionListener<ButtonEvent>() {
						@Override
						public void componentSelected(ButtonEvent ce) {
//							treeHandler.startMapTransect((String) cxNode.get("text"),
//									(String) cxNode.get("tableTransect"),
//									(String) cxNode.get("fieldTransect"));
							menu.hide();
						}
					});
			btTransect.addStyleName("geo-menu_button");
			btTransect.setWidth("100%");
			menuItems.add(btTransect);
		}

		// SLIDER

		Double valueDouble = cxNode.get("opac");
		int value = (int)(valueDouble * 100);
		slider = new Slider();
		slider.setMinValue(0);
		slider.setMaxValue(100);
		slider.setIncrement(5);
		slider.setValue(value);		
		
		slider.addListener(Events.Change, new Listener<SliderEvent>() {
			public void handleEvent(SliderEvent be) {
				@SuppressWarnings("unused")
				double newValue = (double)be.getNewValue() / 100;
				//treeHandler.setOpacityLayer(cxNode_layer, newValue);
			}
		});

		VerticalPanel slider_group = new VerticalPanel();
		slider_group.add(new Label("opacity"));
		slider_group.add(slider);
		slider_group.setStylePrimaryName("gwt-SliderBar-group");

		menuItems.add(slider_group);
		
		menu.setPopupPosition(left + 30, top);
		menu.show();
	}

	public void setHeight(String height) {
		tree.setHeight(height);
	}

	public void setWidth(String width) {
		tree.setWidth(width);
	}

	public void addLayersItems(List<LayerItem> layers) {
		// store creation
		store = new TreeStore<ModelData>();

		// tree panel creation
		tree = new TreePanel<ModelData>(store);
		tree.setTrackMouseOver(false);
		tree.setCheckable(true);
		tree.setCheckNodes(CheckNodes.LEAF);
		tree.setCheckStyle(CheckCascade.NONE);
		tree.setDisplayProperty("name");

		// add layers group "baseLayers"
		BaseTreeModel baseLayers = new BaseTreeModel();
		baseLayers.set("name", "Base Layer");
		baseLayers.set("isFolderNode", new Boolean(true));
		store.add(baseLayers, false);
		
		// add layers group "overlays"
		BaseTreeModel overlays = new BaseTreeModel();
		overlays.set("name", "Overlays");
		overlays.set("isFolderNode", new Boolean(true));
		store.add(overlays, false);

		if (layers.size() > 1) {
			for (LayerItem layerItem : layers) {				
				BaseTreeModel n = new BaseTreeModel();
				n.set("name", layerItem.getName());
				n.set("isFolderNode", new Boolean(false));
				n.set("layer", layerItem.getLayer());
				n.set("hasLegend", new Boolean(layerItem.isHasLegend()));
				n.set("legend", layerItem.getStyle());
				n.set("legends", layerItem.getStyles());
				n.set("maxExtent", layerItem.getMaxExtent());
				n.set("layerItem", layerItem);

				if (layerItem.isHasLegend()) {
					Constants.log("LAYER " + layerItem.getLayer());
					Constants.log("	FIRST FLOAT: "
							+ layerItem.getFirstFloatPropertyName());

					// get layer's property
					List<String> properties = layerItem
							.getAllFloatPropertyNames();
					if (properties.size() == 0)
						Constants.log("	NO PROPERTIES");
					else
						for (int i = 0; i < properties.size(); i++)
							Constants.log("	PROPERTIES " + i + " : "
									+ properties.get(i));

					setTransectInfo(layerItem, n);
				}

				// added by Ceras
				// set layer's opacity
				boolean isBrightLayer = false;
				for (String s : Constants.brightLayers)
					if (s.equals(layerItem.getName()))
						isBrightLayer = true;
				n.set("opac", new Double(isBrightLayer ? 1.0 : Constants.defaultOpacityLayers));

				if (layerItem.isBaseLayer()) {
					n.set("base", true);
					
					store.add(baseLayers, n, false);
					/*
					 * baseLayers.appendChild(n); if(baseLayers.getParentNode()
					 * == null) { root.appendChild(baseLayers); }
					 */
				} else {
					n.set("base", false);
					store.add(overlays, n, false);
					/*
					 * overlays.appendChild(n); if(overlays.getParentNode() ==
					 * null) { root.appendChild(overlays); }
					 */
				}
				tree.setChecked(n, layerItem.isVisible());
				//tree.getStyle().setLeafIcon(IconHelper.create(GWT.getModuleBaseURL()+Constants.layerIcon));
			}
		} else {
			LayerItem layerItem = layers.get(0);

			BaseTreeModel n = new BaseTreeModel();
			n.set("name", layerItem.getName());
			n.set("isFolderNode", new Boolean(false));
			n.set("layer", layerItem.getLayer());
			n.set("hasLegend", new Boolean(layerItem.isHasLegend()));
			n.set("legend", layerItem.getStyle());
			n.set("legends", layerItem.getStyles());
			n.set("maxExtent", layerItem.getMaxExtent());
			n.set("checked", layerItem.isVisible());

			n.set("opac", new Double(Constants.defaultOpacityLayers));

			setTransectInfo(layerItem, n);

			n.set("base", true);
			store.add(overlays, n, false);
			// root.appendChild(n);
		}
		
		// check/unckeck listener
		tree.addListener(Events.CheckChange,
				new Listener<TreePanelEvent<ModelData>>() {
					public void handleEvent(TreePanelEvent<ModelData> be) {
						@SuppressWarnings("unused")
						ModelData modelDataNode = be.getItem();
						if (be.isChecked())
							;//treeHandler.showLayer((String) modelDataNode.get("layer"));
						else
							;//treeHandler.hideLayer((String) modelDataNode.get("layer"));
					}
				});

		// right mouse click listener
		tree.addListener(Events.OnContextMenu,
				new Listener<TreePanelEvent<ModelData>>() {
					public void handleEvent(TreePanelEvent<ModelData> be) {
						((ComponentEvent)be).preventDefault();
						showContextMenu(be);
					}
				});
	}

	// added by ceras
	// sets transect info of a layer into node
	private void setTransectInfo(LayerItem layerItem, BaseTreeModel n) {
		boolean foundDefaultStyle = false;
		Constants.log("NAME LAYER=" + layerItem.getName());
		Constants.log("URL LAYER=" + layerItem.getUrl());
		Constants.log("LAYER : " + layerItem.getStyle());
		for (int i = 0; (i < Constants.defaultStyleTransects.length && !foundDefaultStyle); i++) {
			String styleName = Constants.defaultStyleTransects[i][0];
			String fieldTransect = Constants.defaultStyleTransects[i][1];
			String tableTransect = Constants.defaultStyleTransects[i][2];
			if (layerItem.getStyle().contentEquals(styleName)) {
				n.set("fieldTransect", fieldTransect);
				n.set("tableTransect", tableTransect);
				Constants.log("	Found transect " + i + "; styleName:"
						+ styleName + "- fieldTransect:" + fieldTransect
						+ "- tableTransect:" + tableTransect);
				foundDefaultStyle = true;
			}
		}

		if (!foundDefaultStyle) {
			boolean foundDataStore = false;
			for (int i = 0; (i < Constants.dataStoresWithTransect.length && !foundDataStore); i++) {
				if (layerItem.getDataStore().equals(
						Constants.dataStoresWithTransect[i]))
					foundDataStore = true;
			}

			Constants.log("	The layer is " + (foundDataStore ? "" : "NOT ")
					+ "into dataStore with transect");
			if (foundDataStore) {
				if (layerItem.containsProperty("maxspeciescountinacell")) {
					Constants.log("	Found transect maxspeciescountinacell");
					n.set("fieldTransect", "maxspeciescountinacell");
					n.set("tableTransect", layerItem.getName());
				} else if (layerItem.containsProperty("probability")) {
					Constants.log("	Found transect probability");
					n.set("fieldTransect", "probability");
					n.set("tableTransect", layerItem.getName());
				} else {
					// no transects found
					Constants.log("	No transect found");
					n.set("fieldTransect", "");
					n.set("tableTransect", "");
				}
			} else {
				// the layer is not into dataStore with transects, transects not
				// found
				n.set("fieldTransect", "");
				n.set("tableTransect", "");
			}
		}
	}

	public Widget getTreePanel() {
		return this.tree;
	}

	public void expandTree() {
		tree.expandAll();
	}

	public List<LayerItem> getVisibleLayers() {
		List<ModelData> checkedNodes = tree.getCheckedSelection();
		List<LayerItem> layers = new ArrayList<LayerItem>();
		for (ModelData n : checkedNodes) 
			layers.add((LayerItem)n.get("layerItem"));
		return layers;
	}
}