package org.gcube.portlets.user.gisviewer.client.openlayers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.gcube.portlets.user.gisviewer.client.Constants;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.commons.beans.MapViewInfo;
import org.gwtopenmaps.openlayers.client.Bounds;
import org.gwtopenmaps.openlayers.client.LonLat;
import org.gwtopenmaps.openlayers.client.Map;
import org.gwtopenmaps.openlayers.client.MapOptions;
import org.gwtopenmaps.openlayers.client.MapWidget;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.DrawFeature;
import org.gwtopenmaps.openlayers.client.control.DrawFeature.FeatureAddedListener;
import org.gwtopenmaps.openlayers.client.control.DrawFeatureOptions;
import org.gwtopenmaps.openlayers.client.control.LayerSwitcher;
import org.gwtopenmaps.openlayers.client.control.MouseDefaults;
import org.gwtopenmaps.openlayers.client.control.MousePosition;
import org.gwtopenmaps.openlayers.client.control.MousePositionOptions;
import org.gwtopenmaps.openlayers.client.control.MousePositionOutput;
import org.gwtopenmaps.openlayers.client.control.NavToolbar;
import org.gwtopenmaps.openlayers.client.control.PanZoomBar;
import org.gwtopenmaps.openlayers.client.control.ZoomBox;
import org.gwtopenmaps.openlayers.client.event.MapClickListener;
import org.gwtopenmaps.openlayers.client.feature.VectorFeature;
import org.gwtopenmaps.openlayers.client.geometry.Geometry;
import org.gwtopenmaps.openlayers.client.geometry.Point;
import org.gwtopenmaps.openlayers.client.handler.RegularPolygonHandler;
import org.gwtopenmaps.openlayers.client.handler.RegularPolygonHandlerOptions;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.layer.Vector;
import org.gwtopenmaps.openlayers.client.layer.VectorOptions;
import org.gwtopenmaps.openlayers.client.layer.WMS;
import org.gwtopenmaps.openlayers.client.layer.WMSOptions;
import org.gwtopenmaps.openlayers.client.layer.WMSParams;
import org.gwtopenmaps.openlayers.client.util.JObjectArray;
import org.gwtopenmaps.openlayers.client.util.JSObject;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Widget;

public class OpenLayersMap {

	protected static final int MAX_ZINDEX = 100000;
	private List<LayerItem> layerItems = new ArrayList<LayerItem>();
	private Map map;
	private MapWidget mapWidget;
	private HashMap<String, String> mapping = new HashMap<String, String>();
	private HashMap<LayerItem, Layer> mappingLayerItemsToLayers = new HashMap<LayerItem, Layer>();
	private HashMap<Layer, LayerItem> mappingLayersToLayerItems = new HashMap<Layer, LayerItem>();
	private NavToolbar mouseToolBar;
	private MouseDefaults mouseDefaults;
	//private OverviewMap overViewMap;
	//private MouseClickOnMap mouseClickOnMap;
//	private ToolBarPanelOld toolBarPanel;
	private int numZoomLevels = 0;
	//private String projection = "";
	private Vector vectorLayer;
	private ZoomBox zoomBox;
	private boolean clickData = false;
	private String tableTransect = "";
	private String fieldTransect = "";
	private VectorFeature prevVf;
	public static Bounds defaultBounds = new Bounds(-180, -90, 180, 90);// -180, -90, 180, 90 //-20037508.34,-20037508.34,20037508.34,20037508.34);// TODO -180, -90, 180, 90);
	public static String defaultProjection = "EPSG:4326";
	private List<Layer> baseLayers = new ArrayList<Layer>();
	private String transectUrl;
	//private static String defaultProjection = "EPSG:900913";//"EPSG:4326";
	private DrawFeature drawBoxControl;
	private DrawFeature drawLineControl;
	private OpenLayersHandler handler=null;
	private int maxZindex = 0;
	private ToolBarPanel toolBarPanel;
	
	// constructor
	public OpenLayersMap(String w, String h, int numZoomLevels, // projection, transectUrl removed
			String title, final OpenLayersHandler handler) {

		this.handler = handler;
		this.numZoomLevels = numZoomLevels;
		//this.projection = defaultBounds.;

		// set map options
		MapOptions mapOptions = new MapOptions();
		mapOptions.setControls(new JObjectArray(new JSObject[] {}));
		mapOptions.setNumZoomLevels(numZoomLevels);
		mapOptions.setProjection(defaultProjection);

		// let's create map widget and map objects
		mapWidget = new MapWidget(w, h, mapOptions); // map widget
		map = mapWidget.getMap(); // map js-mapped object		
		mapWidget.setTitle(title); // set title
		map.setMaxExtent(defaultBounds);
		//map.getJSObject().setProperty("allOverlays", true);

		// set click listener on the map
		map.addMapClickListener(new MapClickListener() {
			public void onClick(MapClickEvent mapClickEvent) {
				if (clickData) {
					double lat = mapClickEvent.getLonLat().lat();
					double lon = mapClickEvent.getLonLat().lon();
					addPoint(lon, lat);

//					int x = mapClickEvent.getJSObject().getProperty("xy")
//							.getPropertyAsInt("x");
//					int y = mapClickEvent.getJSObject().getProperty("xy")
//							.getPropertyAsInt("y");

					int w = (int) map.getSize().getWidth();
					int h = (int) map.getSize().getHeight();
//					handler.clickOnMap(x, y, w, h);
					
					// ratio -  mapPixelWeight : bboxWeight = 10px : geoRectangleWidth
					// where 10px is the pixel diameter dimension of the clicked point
					
					double bboxWidth = Math.abs(getExtent().getLowerLeftX() - getExtent().getUpperRightX());
					double geoWidth = bboxWidth / w * 10 / 2;
					System.out.println("("+(lon-geoWidth)+","+(lat-geoWidth)+")("+(lon+geoWidth)+","+(lat+geoWidth)+")");
					double x1 = Math.min(lon+geoWidth, lon-geoWidth);
					double x2 = Math.max(lon+geoWidth, lon-geoWidth);
					double y1 = Math.min(lat+geoWidth, lat-geoWidth);
					double y2 = Math.max(lat+geoWidth, lat-geoWidth);
					System.out.println("("+(x1)+","+(y1)+")("+(x2)+","+(y2)+")");
					handler.selectBox(x1, y1, x2, y2);
				}
			}
		});

		// set the other controls
		mouseDefaults = new MouseDefaults();
		mouseToolBar = new NavToolbar();
		PanZoomBar pamZoomBar = new PanZoomBar();
		zoomBox = new ZoomBox();

		Element e = mouseDefaults.getJSObject().getPropertyAsDomElement("position");
		e.setPropertyDouble("x", -300);
		mouseDefaults.getJSObject().setProperty("position", e);

	
		VectorOptions vectoroptions = new VectorOptions();
		vectoroptions.setDisplayInLayerSwitcher(false);
		vectoroptions.setDisplayOutsideMaxExtent(true);
		vectoroptions.setProjection(defaultProjection);
		vectorLayer = new Vector("transet", vectoroptions);
		map.addLayer(vectorLayer);
		vectorLayer.setZIndex(MAX_ZINDEX);
		
		addBaseLayers();

		addControl(mouseDefaults);
		addControl(pamZoomBar);
		addControl(getMousePosition());
		addControl(zoomBox);
		addControl(new LayerSwitcher());

		addTransectControl();
		addBoxControl();
	}

	/**
	 * 
	 */
	private void addTransectControl() {
		FeatureAddedListener listener = new FeatureAddedListener() {
			public void onFeatureAdded(VectorFeature vf) {
				if (transectUrl==null)
					return;
				org.gwtopenmaps.openlayers.client.geometry.LineString line = org.gwtopenmaps.openlayers.client.geometry.LineString
						.narrowToLineString(vf.getGeometry().getJSObject());

				Double x1;
				Double y1;
				Double x2;
				Double y2;

				try {
					double[][] coordinate = line.getCoordinateArray();

					x1 = coordinate[0][0];
					y1 = coordinate[0][1];
					x2 = coordinate[1][0];
					y2 = coordinate[1][1];
					String url = transectUrl + "?"
							+ "x1=" + x1 + "&" + "y1=" + y1 + "&" + "x2=" + x2
							+ "&" + "y2=" + y2 + "&SRID=4326"
							+ "&maxelements=1000" + "&minimumgap=-1"
							+ "&tablename=" + getTableTransect()
							+ "&biodiversityfield=" + getFieldTransect();

					Window.open(url, "_blank", "");

				} catch (Exception e) {
				}
				vf.destroy();
			}

		};
		
		DrawFeatureOptions drawoptions = new DrawFeatureOptions();
		drawoptions.onFeatureAdded(listener);

		LineHandler handler = new LineHandler();

		drawLineControl = new DrawFeature(vectorLayer, handler, drawoptions);
		addControl(drawLineControl);
	}


	/**
	 * 
	 */
	private void addBoxControl() {
		FeatureAddedListener listener = new FeatureAddedListener() {
			@Override
			public void onFeatureAdded(VectorFeature vf) {
				if (prevVf!=null)
					vectorLayer.removeFeature(prevVf);
				prevVf = vf;
				vectorLayer.setZIndex(MAX_ZINDEX);
				
				Geometry geo = vf.getGeometry();
                Bounds bounds = geo.getBounds();
                double x1 = bounds.getLowerLeftX();
                double y1 = bounds.getLowerLeftY();
                double x2 = bounds.getUpperRightX();
                double y2 = bounds.getUpperRightY();
				handler.selectBox(x1, y1, x2, y2);
			}
		};
		
		DrawFeatureOptions options = new DrawFeatureOptions();
		options.onFeatureAdded(listener);
		RegularPolygonHandlerOptions handlerOptions = new RegularPolygonHandlerOptions();
		handlerOptions.setSides(4);
		handlerOptions.setIrregular(true);
		options.setHandlerOptions(handlerOptions);
		drawBoxControl = new DrawFeature(vectorLayer, new RegularPolygonHandler(), options);
		this.map.addControl(drawBoxControl);
	}

	/**
	 * @return
	 */
	private Control getMousePosition() {
		// set text mouse position (latitude and longitude)
		MousePositionOutput mpOut = new MousePositionOutput() {
			@Override
			public String format(LonLat lonLat, Map map) {
				String out = "";
				out += "<table bgcolor=\"#000000\">";
				out += "<tr><td>";
				out += "<font color=\"#FFFFFF\" align=\"left\"><b>Latitude</b></font></td>";
				out += "<td bgcolor=\"#AAAAAA\"><font color=\"#000000\">";
				out += Util.getFormattedLonLat(lonLat.lat(), "", "");
				// out += lonLat.lat();
				out += "</font></td>";
				out += "<td>";
				out += "<font color=\"#FFFFFF\" align=\"left\"><b>Longitude</b></font></td>";
				out += "<td bgcolor=\"#AAAAAA\"><font color=\"#000000\">";
				out += Util.getFormattedLonLat(lonLat.lon(), "lon", "");
				// out += lonLat.lon();
				out += "</font></td></tr>";
				out += "</table>";

				return out;
			}

		};
		MousePositionOptions mpOptions = new MousePositionOptions();
		mpOptions.setFormatOutput(mpOut);
		MousePosition mousePosition = new MousePosition(mpOptions);
		return mousePosition;
	}

	public void activateZoomOut() {
		mouseToolBar.getJSObject().setProperty("mode", "zoomout");
	}

	public void addLayerItems(List<LayerItem> layerItems, boolean toTop) {
		if (toTop)
			for (LayerItem layerItem : layerItems)
				this.layerItems.add(0, layerItem);
		else
			for (LayerItem layerItem : layerItems)
				this.layerItems.add(layerItem);

		LayerItemsHandler lh = new LayerItemsHandler(layerItems,
				mappingLayerItemsToLayers, mappingLayersToLayerItems);
		List<Layer> ls = lh.getLayers();
		Layer[] lsArray = new Layer[ls.size()];
		ls.toArray(lsArray);
		this.addLayers(lsArray);
	}

	private void addLayers(Layer[] layers) {

		for (Layer l : layers) {
			l.setIsBaseLayer(false);
			l.getJSObject().setProperty("animationEnabled", true);
			l.getJSObject().setProperty("displayInLayerSwitcher", false);
			
			if (l.getName().contentEquals("Google Satellite"))
				mapping.put("Google Satellite", l.getId());
			else {
				String layerName = l.getJSObject().getProperty("params").getPropertyAsString("LAYERS");
				mapping.put(layerName, l.getId());
			}
		}

		map.addLayers(layers);
		//vectorLayer.setZIndex(MAX_ZINDEX);
		
		// OverviewMapOptions overOptions = new OverviewMapOptions();
		// Layer[] ls = new Layer[1];
		// ls[0] = layers[0];
		//
		// overOptions.setLayers(ls);
		//
		// if (Constants.isOverViewMapVisible) {
		// overViewMap = new OverviewMap();
		// addControl(overViewMap);
		// }
	}

//	public void addToolBarOld(ToolBarPanelOld toolBarPanel) {
//		this.toolBarPanel = toolBarPanel;
//	}
//
	/**
	 * @param toolBarPanel2
	 */
	public void addToolBar(ToolBarPanel toolBarPanel) {
		this.toolBarPanel = toolBarPanel;
	}

	private void addControl(Control control) {
		map.addControl(control);
	}

	public List<LayerItem> getLayerItems() {
		return layerItems;
	}

	public Widget getDockPanel() {
		// int zoom=map.getZoomForExtent(map.getMaxExtent(), true);
		// let's center the map to somewhere and set zoom level to 5
		LonLat center = new LonLat(0, 0);
		map.setCenter(center, Constants.openLayersMapDefaultZoom);
		// map.setCenter(center, zoom);

		// eventually add the map widget to div:map
		final DockPanel dockPanel = new DockPanel();

		if (toolBarPanel != null)
			dockPanel.add(toolBarPanel, DockPanel.NORTH);
		
		dockPanel.add(mapWidget, DockPanel.CENTER);

		return dockPanel;

	}

	public void setOpacity(LayerItem layerItem, double opacity) {
		Layer layer = mappingLayerItemsToLayers.get(layerItem);
		if (layer != null)
			layer.setOpacity(new Float(opacity).floatValue());
	}

	public void setVisibility(LayerItem layerItem, boolean visible) {
		Layer layer = mappingLayerItemsToLayers.get(layerItem);
		if (layer != null) {
			layer.setIsVisible(visible);
			layer.redraw();
		}
	}

	public void reproject(String proj) {

		System.out.println("change " + proj);

		MapOptions mapOptions = new MapOptions();
		mapOptions.setControls(new JObjectArray(new JSObject[] {}));
		mapOptions.setNumZoomLevels(this.numZoomLevels);
		mapOptions.setProjection(proj);

		mapWidget.getMap().setOptions(mapOptions);
	}

	public void zoomToMaxExtent() {
		this.map.zoomToMaxExtent();
	}

	public String getProjection() {
		return this.map.getProjection();
	}

	public Bounds getMaxExtent() {
		return this.map.getMaxExtent();
	}

	public Bounds getExtent() {
		return this.map.getExtent();
	}

	public void activateTransectDraw(boolean isActivate) {
		if (isActivate)
			drawLineControl.activate();
		else
			drawBoxControl.deactivate();
	}

	public void activateClickData(boolean isActivate) {
		this.clickData = isActivate;
	}
	
	public void activateDrawBoxControl(boolean isActivate) {
		if (isActivate)
			this.drawBoxControl.activate();
		else
			this.drawBoxControl.deactivate();
		vectorLayer.setZIndex(MAX_ZINDEX);
	}

	public void activateZoomIn(boolean isActivate) {
		if (isActivate)
			zoomBox.activate();
		else
			zoomBox.deactivate();
	}

	public void activatePan(boolean isActivate) {
		if (isActivate)
			mouseDefaults.activate();
		else
			mouseDefaults.deactivate();
	}

	// added by gianpaolo coro in 13-07-11 for returning to cache when
	// CQL_FILTERING is finished
	/*
	 * //String name = this.getLayer(layer).getName(); JSObject layerjs =
	 * this.map.getLayerByName(name).getJSObject(); String url =
	 * layerjs.getPropertyAsString("url");
	 * System.out.println("Switching from Previous URL: "+url); url =
	 * url.replace("geoserver/wms", "geoserver/gwc/service/wms");
	 * layerjs.setProperty("url", url); System.out.println("To New URL: "+url);
	 * //this.map.getLayerByName(name).redraw(true); layer.redraw();
	 */

	public void removeCqlFilter(LayerItem layerItem) {
		Layer layer = mappingLayerItemsToLayers.get(layerItem);

		if (layer!=null) {
			JSObject layerJs = layer.getJSObject();
			layerJs.getProperty("params").setProperty("CQL_FILTER", "include");
			layerItem.setCqlFilter("");

			// switch to the default layer's request url
			String url = layerItem.getUrl();
			layerJs.setProperty("url", url);
			layer.redraw();
		}
	}

	public void setCqlFilter(LayerItem layerItem, String filter) {
		Layer layer = mappingLayerItemsToLayers.get(layerItem);

		if (layer != null) {
			System.out.println("LAYER : " + layerItem.getName() + " FILTER : " + filter);
			JSObject layerJs = layer.getJSObject();
			layerItem.setCqlFilter(filter);
			
			if (filter.equals("")) {
				layerJs.getProperty("params").setProperty("CQL_FILTER", "include");
			} else {
				layerJs.getProperty("params").setProperty("CQL_FILTER", filter);

				// added by gianpaolo coro: In the case of filtering don't use
				// the GWC but directly the wms service
				// this will be used till the next refresh
				String wmsUrl = layerItem.getGeoserverWmsUrl();
				layerJs.setProperty("url", wmsUrl);
			}
			layer.redraw();
		}
	}

	public void setNewStyle(LayerItem layerItem, String newStyle) {
		Layer layer = mappingLayerItemsToLayers.get(layerItem);
		layer.getJSObject().getProperty("params")
				.setProperty("STYLES", newStyle);
		layer.redraw();
	}

	public void setTableTransect(String layerTransect) {
		this.tableTransect = layerTransect;
	}

	public String getTableTransect() {
		return tableTransect;
	}

	public void setFieldTransect(String fieldTransect) {
		this.fieldTransect = fieldTransect;
	}

	public String getFieldTransect() {
		return fieldTransect;
	}

	public void changeSize(String w, String h) {
		// if together are positives
		if (Integer.parseInt(w) > 0 && Integer.parseInt(h) > 0) {
			mapWidget.setWidth(w);
			mapWidget.setHeight(h);
			this.updateSize();
		}
		// mapWidget.setSize(w, h);
	}

	public void updateSize() {
		map.updateSize();
		Constants.info("Update size", "(" + getMapWidth() + ","	+ getMapHeight() + ")");
	}

	public int getMapWidth() {
		return (int) this.map.getSize().getWidth();
	}

	public int getMapHeight() {
		return (int) this.map.getSize().getHeight();
	}

	public MapWidget getMapWidget() {
		return mapWidget;
	}


	public void addPoint(double x, double y) {
		// remove any previuos point
		if (this.prevVf != null)
			vectorLayer.removeFeature(prevVf);

		// add new point
		VectorFeature vf = new VectorFeature(new Point(x, y));
		vectorLayer.addFeature(vf);
		vectorLayer.setZIndex(MAX_ZINDEX);

		// store the point
		this.prevVf = vf;
	}

	public MapViewInfo getMapViewInfo() {
		double lowerLeftX = (getExtent().getLowerLeftX() < getMaxExtent()
				.getLowerLeftX()) ? getMaxExtent().getLowerLeftX()
				: getExtent().getLowerLeftX();
		double lowerLeftY = (getExtent().getLowerLeftY() < getMaxExtent()
				.getLowerLeftY()) ? getMaxExtent().getLowerLeftY()
				: getExtent().getLowerLeftY();
		double upperRightX = (getExtent().getUpperRightX() > getMaxExtent()
				.getUpperRightX()) ? getMaxExtent().getUpperRightX()
				: getExtent().getUpperRightX();
		double upperRightY = (getExtent().getUpperRightY() > getMaxExtent()
				.getUpperRightY()) ? getMaxExtent().getUpperRightY()
				: getExtent().getUpperRightY();
		return new MapViewInfo(lowerLeftX, lowerLeftY, upperRightX,
				upperRightY, getMapWidth(), getMapHeight());
	}

	public void updateLayersOrder() {
//		System.out.println("LAYERS NEW ORDER");
		maxZindex = 0;
		for (Layer layer : baseLayers) {
			if (Integer.parseInt((String)layer.getZIndex())>maxZindex)
				maxZindex = Integer.parseInt((String)layer.getZIndex());
		}

		for (LayerItem layerItem : layerItems) {
//			System.out.println("" + (layerItem.getOrder()+zIndexCounter) + ") "	+ layerItem.getLayer() + " (" + layerItem.getId() + ")");
			Layer layer = mappingLayerItemsToLayers.get(layerItem);
			layer.setZIndex(maxZindex + (int)layerItem.getOrder());
		}
	}

	/**
	 * @param layerItem
	 */
	public void removeLayer(LayerItem layerItem) {
		Layer layer = mappingLayerItemsToLayers.get(layerItem);
		map.removeLayer(layer);
		layerItems.remove(layerItem);
		mappingLayerItemsToLayers.remove(layerItem);
		mappingLayersToLayerItems.remove(layer);
	}

	/**
	 * 
	 */
	private void addBaseLayers() {
//		options = new GoogleV3Options();
//		options.setIsBaseLayer(true);
//		options.setDisplayInLayerSwitcher(true);
//		options.setType(GoogleV3MapType.G_TERRAIN_MAP);
//		googleLayer = new GoogleV3("Google Terrain", options);
//		map.addLayer(googleLayer);
//
		// reproject
//		MapOptions mapOptions = new MapOptions();
//		mapOptions.setControls(new JObjectArray(new JSObject[] {}));
//		mapOptions.setNumZoomLevels(this.numZoomLevels);
//		mapOptions.setProjection("EPSG:900913");
//		mapOptions.setMaxExtent(new Bounds(-20037508.34,-20037508.34,20037508.34,20037508.34));
//		mapOptions.setMaxResolutionToAuto();
//		mapWidget.getMap().setOptions(mapOptions);

		addBaseLayer("True Marble", "truemarble", "http://romeo.jrc.it/maps/mapserv.cgi?map=../mapfiles/acpmap_static.map&");
		addBaseLayer("Blue Marble", "bluemarble_1", "http://iceds.ge.ucl.ac.uk/cgi-bin/icedswms");
		addBaseLayer("Global Surface Relief", "etopo1_ice:z", "http://oos.soest.hawaii.edu/erddap/wms/etopo1_ice/request");
		addBaseLayer("Shaded Relief", "shaded_relief", "http://maps.ngdc.noaa.gov/soap/etopo1/MapServer/WMSServer");
		addBaseLayer("Dem", "dem", "http://maps.ngdc.noaa.gov/soap/etopo1/MapServer/WMSServer");
		addBaseLayer("Etopo180", "etopo180:altitude", "http://coastwatch.pfeg.noaa.gov/erddap/wms/erdBAssta5day/request");
		addBaseLayer("Groundwater Map", "bgr_groundwater_whymap", "http://www.bgr.de/Service/groundwater/whymap/");
		addBaseLayer("LandMask", "LandMask", "http://oos.soest.hawaii.edu/erddap/wms/etopo1_ice/request");
		addBaseLayer("Coastlines", "Coastlines", "http://oos.soest.hawaii.edu/erddap/wms/etopo1_ice/request");
		addBaseLayer("test2", "NWW3_Global_Best:Tdir", "http://oos.soest.hawaii.edu/erddap/wms/NWW3_Global_Best/request");
		addBaseLayer("GEBCO", "GEBCO_08_Grid", "http://www.gebco.net/data_and_products/web_map_service/mapserv/request");
		addBaseLayer("test2", "", ""); // do not anything

		//var extent = new OpenLayers.Bounds(-20037508.34,-20037508.34,20037508.34,20037508.34); //-2200000,-712631,3072800,3840000);
		
//		map = new OpenLayers.Map( 'map', {
//			allOverlays: true, 
//			maxExtent: extent,
//			projection: '900913' //'EPSG:42304'
//		});
		
	}

	/**
	 * @param result
	 */
	public void setTransectUrl(String transectUrl) {
		this.transectUrl = transectUrl;
	}

	public void deactivateDrawBoxControl() {
		this.drawBoxControl.deactivate();
		vectorLayer.setZIndex(MAX_ZINDEX);
	}
	
	public void activateDrawBoxControl() {
		this.drawBoxControl.activate();
		vectorLayer.setZIndex(MAX_ZINDEX);
	}

	/**
	 * @param title
	 * @param layerName
	 * @param url
	 */
	private void addBaseLayer(String title, String layerName, String url) {
		if (url==null || url.equals("") || layerName==null || layerName.equals(""))
			return;
		LayerItem l = new LayerItem(true);
		l.setTitle(title);
		l.setName(layerName);
		l.setLayer(layerName);
		l.setGeoserverWmsUrl(url);
		l.setBaseLayer(true);
		l.setOpacity(1d);
		addLayerItemByWms(l, true);
	}

	/**
	 * @param layerItem
	 * @param displayInLayerSwitcher
	 */
	public void addLayerItemByWms(LayerItem layerItem, boolean displayInLayerSwitcher) {
		WMSOptions wmsOptions = new WMSOptions();
		wmsOptions.setIsBaseLayer(layerItem.isBaseLayer());
		wmsOptions.setBuffer(2); // from serviceimpl
		wmsOptions.setWrapDateLine(true); // default
		WMSParams wmsParams = new WMSParams();
		wmsParams.setLayers(layerItem.getLayer());
		wmsParams.setIsTransparent(!layerItem.isBaseLayer());
		wmsParams.setFormat("image/png");
		//wmsParams.setMaxExtent(defaultBounds);
		Layer layer = new WMS(layerItem.getTitle(), layerItem.getGeoserverWmsUrl(), wmsParams, wmsOptions);
		layer.setDisplayInLayerSwitcher(displayInLayerSwitcher);
		mappingLayerItemsToLayers.put(layerItem, layer);
		mappingLayersToLayerItems.put(layer, layerItem);
		map.addLayer(layer);
		
		if (layerItem.isBaseLayer())
			baseLayers.add(layer);
		else
			layerItems.add(layerItem);
	}

	/**
	 * @return
	 */
	public LayerItem getActiveBaseLayer() {
		for (Layer l : baseLayers)
			if (l.isVisible())
				return mappingLayersToLayerItems.get(l);
		return null;
	}

	/**
	 * 
	 */
	public void zoomOut() {
		int z = map.getZoom();
		System.out.println("ACTUAL:" + z);
		map.zoomTo(z-1);
	}

	/**
	 * 
	 */
	public void removeDataFeature() {
		if (prevVf!=null) {
			vectorLayer.removeFeature(prevVf);
			prevVf = null;
		}
	}
}
