package org.gcube.portlets.session.client;

import org.gcube.portlets.session.client.BaseItem;


/**
 * The <code> DraggableImage </code> 
 *
 * @author massimiliano.assante@isti.cnr.it
 * @version 7.11
 */
public class DraggableImage extends BaseItem  {
	
	/**
	 * the thubnail URL
	 */
	protected String thumb;
	
	/**
	 * Constructor
	 */
	public DraggableImage() {
		super();
		this.thumb = null;
	}

	/**
	 * Constructor
	 * 
	 * @param thumb t
	 * @param id i
	 * @param label l
	 * @param metadata m
	 * @param content c
	 */
	public DraggableImage(String thumb, int id, String label, String metadata, String content) {
		super(id, "IMG", "JPEG", label, metadata, content);
		this.thumb = thumb;
	}

	/**
	 * Constructor
	 * 
	 * @param thumb t
	 * @param id i
	 * @param label l
	 */
	public DraggableImage(String thumb, int id, String label) {
		super(id, "IMG", "JPEG", label, null, null);
		this.thumb = thumb;
	}

	/**
	 * 
	 * @return t
	 */
	public String getThumb() {
		return thumb;
	}

	/**
	 * 
	 * @param thumb t
	 */
	public void setThumb(String thumb) {
		this.thumb = thumb;
	}

}
