package org.gcube.portlets.session.client;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * The <code> BaseItem </code> is the basic item tha can be put inside the basket 
 * each item that can be placed in the basket has to extends this class.
 *
 * @author massimiliano.assante@isti.cnr.it
 * @version march 2007 (1.0) 
 */

public class BaseItem implements IsSerializable {

	
//	 INSTANCE VARIABLES ***********************************************
	
	/**
	 * 	the identifier for the object d
	 */
	protected int id;
	
	/**
	 * 	to know which kind of object is 
	 */
	
	protected String type;
	
	protected String mimeType;
	
	/**
	 *  the eventual label to display in the basket
	 */
	protected String label ;
	
	protected String metadata;
	
	protected String content;
	
	/**
	 * 
	 */
	protected String fileName;
	
	
//	 CONSTRUCTORS *****************************************************
	


	/**
	 *  constructs an empty BaseItem
	 */
	public BaseItem() {
		super();
		this.id = -1;
		this.type = null;
		this.mimeType = null;
		this.label = null;
		this.metadata = null;
		this.content = null;
	}


	/**
	 * constructs the base item
	 *  
	 * @param id  the identifier 
	 * @param mimeType  the mimeType
	 * @param type  the type of the file
	 * @param label  the label to display when the widget is inside the basket
	 * @param metadata m
	 * @param content c
	 */
	public BaseItem(int id, String type, String mimeType, String label, String metadata, String content) {
		super();
		this.id = id;
		this.type = type;
		this.mimeType = mimeType;
		this.label = label;
		this.metadata = metadata;
		this.content = content;
	}


//	 INSTANCE METHODS *************************************************
	/**
	 * @return mimeType
	 */
	public String getMimeType() {
		return mimeType;
	}
	
	/**
	 * 
	 * @param mimeType m
	 */
	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}

	/**
	 * 
	 * @return label
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * 
	 * @param label l
	 */
	public void setLabel(String label) {
		this.label = label;
	}
	
	/**
	 * 
	 * @return content
	 */
	public String getContent() {
		return content;
	}

	/**
	 * 
	 * @param content c
	 */
	public void setContent(String content) {
		this.content = content;
	}

	/**
	 * 
	 * @return id
	 */
	public int getId() {
		return id;
	}

	/**
	 * 
	 * @param id the ID
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * 
	 * @return metadata
	 */
	public String getMetadata() {
		return metadata;
	}

	/**
	 * 
	 * @param metadata m
	 */
	public void setMetadata(String metadata) {
		this.metadata = metadata;
	}

/**
 * 
 * @return type
 */
	public String getType() {
		return type;
	}

	/**
	 * 
	 * @param type t
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * 
	 * @return fname
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * 
	 * @param fileName f
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

}
