package org.gcube.resourcemanagement.model.reference.entity.properties;

import java.util.Set;

import org.gcube.informationsystem.model.reference.embedded.Embedded;
import org.gcube.resourcemanagement.model.impl.entity.properties.EnumStringPropertyImpl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;


/**
 * A string property validated against a set of accepted values.
 * 
 * @author Manuele Simi (ISTI CNR)
 *
 */
@JsonDeserialize(as=EnumStringPropertyImpl.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public interface EnumStringProperty extends Embedded, GCubeEmbedded, ValidatedTypedProperty<Set<String>, String> {
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gcube.informationsystem.model.reference.embedded.
	 * ValidatedTypedProperty#validate()
	 */
	@Override
	default Validation validate() {
		return new SetStringValidator().validate(this);
	}

	/**
	 * Validator for {@link ValueSchema} properties.
	 * 
	 * @author Manuele Simi (ISTI CNR)
	 *
	 */
	class SetStringValidator implements PropertyValidator<EnumStringProperty> {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.gcube.informationsystem.model.reference.embedded.
		 * PropertyValidator#validate(org.gcube.informationsystem.model.
		 * reference.embedded.TypedProperty)
		 */
		@Override
		public Validation validate(EnumStringProperty property) {
			return property.getType().contains(property.getValue()) ? Validation.success("Accepted!")
					: Validation.fail(property.getValue() + " is not a valid value.");
		}
	}
}
