package org.gcube.resourcemanagement.model.reference.entity.properties;

import java.net.URI;

import org.gcube.informationsystem.model.reference.annotations.ISProperty;
import org.gcube.informationsystem.model.reference.embedded.Embedded;
import org.gcube.resourcemanagement.model.impl.entity.properties.ValueSchemaImpl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * A property with an {@link URI} as value
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=ValueSchemaImpl.class)
public interface ValueSchema extends Embedded, GCubeEmbedded, ValidatedTypedProperty<URI,String> {

	public static final String NAME = "ValueSchema"; //ValueSchema.class.getSimpleName();
	
	/* (non-Javadoc)
	 * @see org.gcube.informationsystem.model.reference.embedded.ValidatedTypedProperty#validate()
	 */
	@Override
	default Validation validate() {
		return new SchemaValidator().validate(this);
	}
	
	/**
	 * Validator for {@link ValueSchema} properties. 
	 * @author Manuele Simi (ISTI CNR)
	 *
	 */
	class SchemaValidator implements PropertyValidator<ValueSchema> {

		/* (non-Javadoc)
		 * @see org.gcube.informationsystem.model.reference.embedded.PropertyValidator#validate(org.gcube.informationsystem.model.reference.embedded.TypedProperty)
		 */
		@Override
		public Validation validate(ValueSchema property) {
			//TODO validate the string against the URI!
			
			return Validation.success("Accepted!");
		}
	}
	
	
	@ISProperty
	@Override
	public String getValue();
	
	@Override
	public void setValue(String value);
	
	@ISProperty
	@Override
	public URI getType();
	
	@Override
	public void setType(URI type);
	
}
