/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.resources;

import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.resourcemanagement.model.impl.entities.resources.ConfigurationImpl;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.IsDerivationOf;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;


/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Configuration
 */
@JsonDeserialize(as=ConfigurationImpl.class)
@ResourceSchema(
	resources = {
			@ResourceSchemaRelatedEntry(source=Configuration.class, relation=IsDerivationOf.class, target=ConfigurationTemplate.class)
	}
)
public interface Configuration extends ConfigurationTemplate {
	
	public static final String NAME = "Configuration"; // Configuration.class.getSimpleName();
	public static final String DESCRIPTION = "An instance of a configuration template characterising the behaviour and shape of the resource it is attached to.";
	public static final String VERSION = "1.0.0";
	
}