/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.resources;

import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.resourcemanagement.model.impl.entities.resources.PluginImpl;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.IsPluginOf;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;


/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Plugin
 */
@JsonDeserialize(as=PluginImpl.class)
@ResourceSchema(
	resources= {
		@ResourceSchemaRelatedEntry(source=Plugin.class, relation=IsPluginOf.class, target=Software.class, description="A reference to the Software this Plugin is conceived to extend the capabilities.")
	}
)
public interface Plugin extends Software {
	
	public static final String NAME = "Plugin"; // Plugin.class.getSimpleName();
	public static final String DESCRIPTION = "Collect Plugin information through the list of its facets";
	public static final String VERSION = "1.0.0";
}
