/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.resources;

import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.resourcemanagement.model.impl.entities.resources.PersonImpl;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.BelongsTo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Person
 */
@JsonDeserialize(as = PersonImpl.class)
@ResourceSchema(
	resources = {
			@ResourceSchemaRelatedEntry(source = Person.class, relation = BelongsTo.class, target = LegalBody.class)
	}
)
public interface Person extends Actor {
	
	public static final String NAME = "Person"; // Person.class.getSimpleName();
	public static final String DESCRIPTION = "Any human playing the role of Actor.";
	public static final String VERSION = "1.0.0";
	
}
