/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.resources;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.resourcemanagement.model.impl.entities.resources.LegalBodyImpl;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.BelongsTo;


/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Legal_Body
 */
@JsonDeserialize(as=LegalBodyImpl.class)
@ResourceSchema(
	resources= {
		@ResourceSchemaRelatedEntry(source=Person.class, relation=BelongsTo.class, target=LegalBody.class)
	}
)
public interface LegalBody extends Actor {

	public static final String NAME = "LegalBody"; // LegalBody.class.getSimpleName();
	public static final String DESCRIPTION = "A legal entity playing the role of an Actor.";
	public static final String VERSION = "1.0.0";
		
}
