/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.resources;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaEntry;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.resourcemanagement.model.impl.entities.resources.VirtualServiceImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.SoftwareFacet;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Demands;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Virtual_Service
 */
@JsonDeserialize(as=VirtualServiceImpl.class)
@ResourceSchema(
	facets={
		@ResourceSchemaEntry(relation=IsIdentifiedBy.class, facet=SoftwareFacet.class, min=1),
	},
	resources= {
		@ResourceSchemaRelatedEntry(source=VirtualService.class, relation=Demands.class, target=Software.class)
	}
)
public interface VirtualService extends Service {
	
	public static final String NAME = "VirtualService"; // VirtualService.class.getSimpleName();
	public static final String DESCRIPTION = "An abstract service (non physically existing service) worth being represented as an existing Service for management purposes. Examples of usage include cases where classes or set of services are to be managed like an existing unit.";
	public static final String VERSION = "1.0.0";
}
