/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import java.util.List;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.resourcemanagement.model.impl.entities.facets.TemplateFacetImpl;
import org.gcube.resourcemanagement.model.reference.properties.AttributeProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Named;

@JsonDeserialize(as=TemplateFacetImpl.class)
@TypeMetadata(name="TemplateFacet", description="This facet define a template for a Facet to instantiate using the list of attributes specified. The type of the instatianted facet is specified in 'targetFacetType' attribute", version="1.0.0")
@Change(version="1.0.0", description="First Version")
public interface TemplateFacet
extends Facet,
Named {
    public static final String NAME = "TemplateFacet";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String TARGET_TYPE_PROPERTY = "targetType";
    public static final String PROPERTIES_PROPERTY = "properties";

    @Override
    @ISProperty(name="name", description="The name of the template", mandatory=true, nullable=false)
    public String getName();

    @Override
    public void setName(String var1);

    @ISProperty(name="description", description="The description of the template", readonly=false, mandatory=true, nullable=false)
    public String getDescription();

    public void setDescription(String var1);

    @ISProperty(name="targetType", description="The type of Facet to instantiate with the attributes valued", readonly=false, mandatory=true, nullable=false)
    public String getTargetType();

    public void setTargetType(String var1);

    @ISProperty(name="properties", description="The attributes of the template to be created when instantiated", readonly=false, mandatory=true, nullable=false, min=1)
    public List<AttributeProperty> getProperties();

    public void setProperties(List<AttributeProperty> var1);

    @JsonIgnore
    public void addProperty(AttributeProperty var1);
}

