package org.gcube.resourcemanagement.context;

import java.util.UUID;

import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;


/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class TargetContext {

    protected ResourceRegistryClient client;
    protected ContextCache contextCache;

    protected String contextFullPath;
    protected UUID uuid;
    protected Context context;
    protected Secret secret;

    protected void init(){
        this.client = ResourceRegistryClientFactory.create();
        this.contextCache = client.getContextCache();
    }

    public TargetContext(){
    }

    /**
     * The provided context must be part of a tree of contexts
     * @param context
          * @throws ResourceRegistryException 
          */
    public TargetContext(Context context) throws ResourceRegistryException {
        this(context.getID());
    }
    
    public TargetContext(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        init();
        this.context = contextCache.getContextByUUID(uuid);
        this.uuid = uuid;
        this.contextFullPath = contextCache.getContextFullNameByUUID(uuid);
    }

    public TargetContext(String contextFullPath) throws ContextNotFoundException, ResourceRegistryException{
        init();
        this.context = contextCache.getContextByFullName(contextFullPath);
        this.contextFullPath = contextFullPath;
        this.uuid = context.getID();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String getContextFullPath() {
        return contextFullPath;
    }

    public void setContextFullPath(String contextFullPath) {
        this.contextFullPath = contextFullPath;
    }

    public Context getContext() {
        return context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

}
