/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.manager.webapp.context;

import java.util.Objects;
import org.gcube.common.gxrest.response.outbound.ErrorCode;
import org.gcube.common.gxrest.response.outbound.LocalCodeException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientImpl;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClient;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClientFactory;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClientImpl;
import org.gcube.resourcemanagement.manager.webapp.context.ResponseFromResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestToResourceRegistry {
    protected ResourceRegistryContextClient resourceRegistryContextClient;
    private ResourceRegistryClientImpl resourceResourceRegistryClient;
    protected static Logger logger = LoggerFactory.getLogger(RequestToResourceRegistry.class);

    public RequestToResourceRegistry forceURL(String forceURL) {
        this.resourceRegistryContextClient = new ResourceRegistryContextClientImpl(forceURL);
        this.resourceResourceRegistryClient = new ResourceRegistryClientImpl(forceURL);
        return this;
    }

    public abstract void validate() throws LocalCodeException;

    public ResponseFromResourceRegistry submit() {
        if (Objects.isNull(this.resourceRegistryContextClient)) {
            this.resourceRegistryContextClient = ResourceRegistryContextClientFactory.create();
        }
        try {
            this.validate();
        }
        catch (LocalCodeException e) {
            ResponseFromResourceRegistry response = ResponseFromResourceRegistry.fromErrorCode((ErrorCode)e);
            return response;
        }
        return this.validateResponse(this.send());
    }

    protected ResponseFromResourceRegistry validateResponse(ResponseFromResourceRegistry response) {
        return response;
    }

    ResourceRegistryContextClient getContextClient() {
        if (Objects.nonNull(this.resourceRegistryContextClient)) {
            return this.resourceRegistryContextClient;
        }
        return ResourceRegistryContextClientFactory.create();
    }

    ResourceRegistryClient getRegistryClient() {
        if (Objects.nonNull(this.resourceResourceRegistryClient)) {
            return this.resourceResourceRegistryClient;
        }
        return ResourceRegistryClientFactory.create();
    }

    protected abstract ResponseFromResourceRegistry send();
}

