/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.manager.webapp.rs;

import java.net.URI;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.gxrest.response.outbound.ErrorCode;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.gxrest.response.outbound.GXOutboundSuccessResponse;
import org.gcube.resourcemanagement.manager.webapp.context.ContextHolder;
import org.gcube.resourcemanagement.manager.webapp.context.CreateRequest;
import org.gcube.resourcemanagement.manager.webapp.context.DeleteRequest;
import org.gcube.resourcemanagement.manager.webapp.context.ResponseFromResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="context")
public class RMContext {
    private static Logger logger = LoggerFactory.getLogger(RMContext.class);

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response create(String json, @QueryParam(value="rrURL") String rrURL) {
        CalledMethodProvider.instance.set(String.format("POST /%s/%s", "/resource-manager", "context"));
        logger.info("Requested to create context {} with json {}", (Object)"Context", (Object)json);
        logger.info("Force URL: " + rrURL);
        ContextHolder holder = new ContextHolder(json);
        ResponseFromResourceRegistry returned = CreateRequest.fromHolder((ContextHolder)holder).forceURL(rrURL).submit();
        if (!returned.wasSuccessful()) {
            if (returned.getException().isPresent()) {
                GXOutboundErrorResponse.throwException((Exception)((Exception)returned.getException().get()));
            } else if (returned.getErrorCode().isPresent()) {
                GXOutboundErrorResponse.throwErrorCode((ErrorCode)((ErrorCode)returned.getErrorCode().get()));
            } else {
                GXOutboundErrorResponse.throwException((Exception)new Exception("Failed to create the context."));
            }
        }
        return GXOutboundSuccessResponse.newCREATEResponse((URI)returned.getLocation()).withContent("Context successfully created.").ofType("text/plain").build();
    }

    @DELETE
    @Path(value="{ContextUUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response delete(@PathParam(value="ContextUUID") String uuid, @QueryParam(value="rrURL") String rrURL) {
        CalledMethodProvider.instance.set(String.format("DELETE /%s/%s/ID", "/resource-manager", "context"));
        logger.info("Requested to delete context with id {}", (Object)uuid);
        logger.info("Force URL: " + rrURL);
        ResponseFromResourceRegistry returned = DeleteRequest.fromUUID((UUID)UUID.fromString(uuid)).forceURL(rrURL).submit();
        if (!returned.wasSuccessful()) {
            if (returned.getException().isPresent()) {
                GXOutboundErrorResponse.throwException((Exception)((Exception)returned.getException().get()));
            } else if (returned.getErrorCode().isPresent()) {
                GXOutboundErrorResponse.throwErrorCode((ErrorCode)((ErrorCode)returned.getErrorCode().get()));
            } else {
                GXOutboundErrorResponse.throwException((Exception)new Exception("Failed to delete the context."));
            }
        }
        return GXOutboundSuccessResponse.newOKResponse().withContent("Context successfully deleted.").ofType("text/plain").build();
    }
}

