package org.gcube.common.vremanagement.deployer.impl.resources.undeployment;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.contexts.ServiceContext;


/**
 * 
 * Detects if a file is part of the gCore distribution package
 *
 * @author Manuele Simi (ISTI-CNR)
 *
 */
class GCOREFileList {

	static Set<String> files = new HashSet<String>();
	static GCUBELog logger = new GCUBELog(GCOREFileList.class);
	
	static {		
		String gcorefile = (String) ServiceContext.getContext().getProperty("gcore-filelist",false);
		
		try {
			FileInputStream fstream = new FileInputStream(ServiceContext.getContext().getFile(gcorefile));

		    // Convert our input stream to a BufferedReader
		    BufferedReader in = new BufferedReader (new InputStreamReader(fstream));

		    // Continue to read lines while there are still some left to read
		    String inputLine;
		    StringBuilder content = new StringBuilder();
		    while ((inputLine = in.readLine()) != null )
		    	content.append(inputLine);
		    
			String[] templist = content.toString().split(",");
			for (String file : templist) 
				files.add(file.trim());
			logger.debug("gCore file list correctly loaded");
		} catch (IOException e) {
			logger.error("Unable to read the gCore file list", e);			
		}
		
		
	}
		
	static boolean isAgCoreFile(String file) {
		if (files.isEmpty())
			logger.warn("the gCore file list is empty");
		if (files.contains(file.trim()))
			return true;
		return false;
	}		
	
}
