/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.deployment;

import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Dependency;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntRunner;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InstallScheduler;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.RebootScheduler;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.KeyData;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.Deployable;

public abstract class DeployablePackage
extends BaseTypedPackage
implements Deployable {
    private static final long serialVersionUID = -3579799875441746994L;
    protected transient PackageExtractor extractor;
    protected transient AntRunner run;
    protected transient GCUBEService serviceprofile;
    protected String serviceID;
    protected Calendar deploymentTime;

    DeployablePackage(Package packagefile, PackageExtractor extractor) throws Exception {
        super(extractor.getServiceProfile().getServiceClass(), extractor.getServiceProfile().getServiceName(), extractor.getServiceProfile().getVersion(), packagefile.getName(), packagefile.getVersion());
        this.extractor = extractor;
        this.key = new KeyData(this.extractor.getServiceProfile().getServiceClass(), this.extractor.getServiceProfile().getServiceName(), this.extractor.getServiceProfile().getVersion(), packagefile.getName(), packagefile.getVersion());
        this.serviceID = this.extractor.getServiceProfile().getID();
        this.logger.debug((Object)("DeployablePackage created for: " + packagefile.getName()));
        this.serviceprofile = this.extractor.getServiceProfile();
        try {
            this.run = new AntRunner();
            this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
        }
        catch (Exception e) {
            this.logger.error((Object)("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName()), (Throwable)e);
            throw new Exception("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName());
        }
    }

    protected final void analysePackage() {
        this.extractInstallScripts();
        this.extractsRebootScripts();
        this.extractsUninstallScripts();
        this.extractDependencies();
        if (this.getPackageProfile().getTargetPlatform() != null) {
            this.setTargetPlatform(this.getPackageProfile().getTargetPlatform());
        }
    }

    @Override
    public final void deploy(Set<GCUBEScope> targets) throws DeployException, InvalidPackageArchiveException {
        this.preDeploy();
        this.deployPackage(targets);
        this.setScopes(targets);
        this.manageScripts();
        this.postDeploy();
        this.notifyDeployCompleted();
    }

    public abstract void deployPackage(Set<GCUBEScope> var1) throws DeployException, InvalidPackageArchiveException;

    protected abstract Package getPackageProfile();

    public GCUBEService getServiceProfile() {
        return this.serviceprofile;
    }

    protected void runInstallScripts() throws DeployException, InvalidPackageArchiveException {
        List<String> scripts = this.getInstallScripts();
        if (scripts == null) {
            return;
        }
    }

    private void extractInstallScripts() {
        if (this.extractor == null) {
            return;
        }
        String dir = this.extractor.getPackageFilesDir();
        List profile_scripts = this.getPackageProfile().getInstallScripts();
        if (profile_scripts == null) {
            return;
        }
        for (String script : profile_scripts) {
            this.logger.debug((Object)("Scheduling " + dir + File.separator + script + " as install script for " + this.key.getPackageName() + "..."));
            this.addInstallScript(dir + File.separator + script);
        }
    }

    @Override
    public final void clean() throws DeployException {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("package.source.dir", Configuration.BASESOURCEDIR);
            properties.put("base.deploy.dir", Configuration.BASEDEPLOYDIR);
            this.run.setProperties(properties, true);
            this.run.runTarget("deleteTempFiles");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException("Unable to cleanup the package " + this.key.getPackageName() + ": " + aie.getMessage());
        }
    }

    @Override
    public void preDeploy() throws InvalidPackageArchiveException, DeployException {
    }

    @Override
    public void postDeploy() throws InvalidPackageArchiveException, DeployException {
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public final Calendar getDeploymentTime() {
        return this.deploymentTime;
    }

    protected final void notifyDeployCompleted() {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone("GMT"));
            this.deploymentTime = calendar;
        }
        catch (Exception e) {
            this.logger.warn((Object)"unable to detect the current time in the default time zone with the default locale ", (Throwable)e);
        }
    }

    private void extractsRebootScripts() {
        if (this.extractor == null) {
            return;
        }
        String dir = this.extractor.getPackageFilesDir();
        List profile_scripts = this.getPackageProfile().getRebootScripts();
        if (profile_scripts == null) {
            return;
        }
        for (String script : profile_scripts) {
            this.logger.debug((Object)("package deployer is scheduling " + dir + File.separator + script + " as reboot script for " + this.key.getPackageName() + "..."));
            this.addRebootScript(dir + File.separator + script);
        }
    }

    private void extractDependencies() {
        HashSet<KeyData> deps = new HashSet<KeyData>();
        for (Dependency dep : this.getPackageProfile().getDependencies()) {
            deps.add(new KeyData(dep.getService().getClazz(), dep.getService().getName(), dep.getService().getVersion(), dep.getPackage(), dep.getVersion()));
        }
        this.addDependencies(deps);
    }

    private void manageScripts() throws InvalidPackageArchiveException, DeployException {
        InstallScheduler.getScheduler().add(this);
        InstallScheduler.getScheduler().run(this.getKey());
        RebootScheduler.getScheduler().add(this);
    }

    private void extractsUninstallScripts() {
        if (this.extractor == null) {
            return;
        }
        String dir = this.extractor.getPackageFilesDir();
        List profile_scripts = this.getPackageProfile().getUninstallScripts();
        if (profile_scripts == null) {
            return;
        }
        for (String script : profile_scripts) {
            this.logger.debug((Object)("package deployer is scheduling " + dir + File.separator + script + " as unistall script for " + this.key.getPackageName() + "..."));
            this.addUninstallScript(dir + File.separator + script);
        }
    }

    @Override
    public String deployApp(Set<GCUBEScope> targets) throws DeployException, InvalidPackageArchiveException {
        this.deploy(targets);
        return "";
    }

    @Override
    public BaseTypedPackage getSourcePackage() {
        return this;
    }
}

