/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.deployment;

import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.resources.service.Plugin;
import org.gcube.common.core.resources.service.Software;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.ExternalPackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DApplicationPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DExternalLibraryPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DLibraryPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DMainPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DPlatformApplication;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DPlugin;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.Deployable;

public class DeployablePackageFactory {
    public static Deployable createDeployablePackageFromProfile(Package packageprofile, PackageExtractor extractor) throws InvalidPackageArchiveException, Exception {
        if (MainPackage.class.isAssignableFrom(packageprofile.getClass())) {
            return new DMainPackage((MainPackage)packageprofile, extractor);
        }
        if (Software.class.isAssignableFrom(packageprofile.getClass())) {
            Software s = (Software)packageprofile;
            if (s.getType() == Software.Type.library) {
                return new DLibraryPackage(s, extractor);
            }
            if (s.getType() == Software.Type.application) {
                return new DApplicationPackage(s, extractor);
            }
            if (s.getType() == Software.Type.webapplication) {
                return new DPlatformApplication(s, extractor);
            }
        }
        if (Plugin.class.isAssignableFrom(packageprofile.getClass())) {
            return new DPlugin((Plugin)packageprofile, extractor);
        }
        throw new InvalidPackageArchiveException();
    }

    public static Deployable createDeployablePackageFromJar(ExternalPackageExtractor extractor) throws InvalidPackageArchiveException, Exception {
        return new DExternalLibraryPackage(extractor);
    }
}

