/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.deployment;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.resources.service.Plugin;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntRunner;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DeployablePackage;

public class DPlugin
extends DeployablePackage {
    private static final long serialVersionUID = -5582413387483432642L;
    protected String baseTargetDir = GHNContext.getContext().getLocation() + File.separator + "lib" + File.separator;
    protected transient Plugin packageprofile;

    public DPlugin(Plugin packageprofile, PackageExtractor extractor) throws Exception {
        super((Package)packageprofile, extractor);
        this.packageprofile = packageprofile;
        this.setType(BaseTypedPackage.TYPE.PLUGIN);
        this.analysePackage();
        StringWriter writer = new StringWriter();
        try {
            this.getServiceProfile().store((Writer)writer);
            this.properties.put("SerializedProfile", writer.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to serialize the Service profile", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deployPackage(Set<GCUBEScope> targets) throws DeployException, InvalidPackageArchiveException {
        this.logger.debug((Object)("Deploying the plugin package " + this.getKey().getPackageName() + " in scope(s) " + targets.toString()));
        this.deployPlugin(this.packageprofile.getFiles());
        this.setScopesToAdd(targets);
    }

    @Override
    protected Package getPackageProfile() {
        return this.packageprofile;
    }

    @Override
    public boolean requireRestart() {
        return true;
    }

    @Override
    public boolean verify() throws InvalidPackageArchiveException {
        for (File pluginFile : this.getPackageFileList()) {
            this.logger.warn((Object)("Verifying library file " + pluginFile.getName() + "..."));
            if (pluginFile.exists()) continue;
            try {
                this.logger.warn((Object)("Plugin file " + pluginFile.getCanonicalPath() + " not correctly deployed"));
            }
            catch (IOException e) {
                throw new InvalidPackageArchiveException("Unable to check library file " + pluginFile.getName());
            }
            return false;
        }
        return true;
    }

    private void deployPlugin(List<String> pluginfiles) throws DeployException, InvalidPackageArchiveException {
        for (String file : pluginfiles) {
            try {
                this.run = new AntRunner();
                this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
            }
            catch (Exception e) {
                this.logger.error((Object)("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName()), (Throwable)e);
                throw new DeployException("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName());
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("service.id", this.extractor.getServiceKey());
            properties.put("package.name", this.getKey().getPackageName());
            properties.put("package.file", this.extractor.getDownloadedFile().getName());
            properties.put("package.source.dir", Configuration.BASESOURCEDIR);
            properties.put("base.deploy.dir", Configuration.BASEDEPLOYDIR);
            properties.put("jar.name", file.trim());
            try {
                this.run.setProperties(properties, true);
                this.run.runTarget("deployLibrary");
            }
            catch (AntInterfaceException aie) {
                throw new DeployException(aie.getMessage());
            }
            String[] filetokens = file.split(File.separator);
            this.addFile2Package(new File(this.baseTargetDir + filetokens[filetokens.length - 1]));
            Plugin.TargetService service = this.packageprofile.getTargetService();
            this.properties.put("Class", service.getClazz());
            this.properties.put("Name", service.getName());
            this.properties.put("Version", service.getVersion());
            this.properties.put("TargetPackage", service.getTargetPackage());
            this.properties.put("TargetVersion", service.getTargetVersion());
        }
    }
}

