/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.state;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CountableHashMap<K, V>
extends HashMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -4631590796792866098L;
    private Map<K, Integer> keycounter = new HashMap<K, Integer>();

    public CountableHashMap() {
    }

    public CountableHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CountableHashMap(Map<K, V> m) {
        super(m);
    }

    public CountableHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    public void clear() {
        this.keycounter.clear();
        super.clear();
    }

    @Override
    public V put(K key, V value) {
        V v;
        if (this.keycounter.containsKey(key)) {
            Integer i;
            Integer n = i = this.keycounter.get(key);
            Integer n2 = i = Integer.valueOf(i + 1);
            v = super.get(key);
        } else {
            v = super.put(key, value);
            this.keycounter.put(key, 1);
        }
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Object v;
        if (this.keycounter.containsKey(key)) {
            Integer i = this.keycounter.get(key);
            if (1 == i) {
                v = super.remove(key);
                this.keycounter.remove(key);
            } else {
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i - 1);
                v = super.get(key);
            }
        } else {
            v = super.remove(key);
        }
        return v;
    }

    public int countableRemove(Object key) {
        this.remove(key);
        if (this.keycounter.containsKey(key)) {
            return this.keycounter.get(key);
        }
        return 0;
    }

    public int countablePut(K key, V value) {
        this.put(key, value);
        return this.keycounter.get(key);
    }

    public Map<? extends K, Integer> countablePutAll(Map<? extends K, ? extends V> m) {
        this.putAll(m);
        HashMap<K, Integer> counters = new HashMap<K, Integer>();
        for (Map.Entry<K, V> e : m.entrySet()) {
            counters.put(e.getKey(), this.keycounter.get(e.getKey()));
        }
        return counters;
    }

    public int getCounter(Object key) {
        if (this.keycounter.containsKey(key)) {
            return this.keycounter.get(key);
        }
        return 0;
    }
}

