/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.deployment;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.resources.service.Software;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntRunner;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DeployablePackage;

class DLibraryPackage
extends DeployablePackage {
    private static final long serialVersionUID = -4041391555933447325L;
    protected String baseLibTargetDir = GHNContext.getContext().getLocation() + File.separator + "lib" + File.separator;
    protected transient Software packageprofile;
    private transient List<String> jars = new ArrayList<String>();

    public DLibraryPackage(Software packageprofile, PackageExtractor extractor) throws Exception {
        super((Package)packageprofile, extractor);
        this.packageprofile = packageprofile;
        this.analysePackage();
        this.setType(BaseTypedPackage.TYPE.LIBRARY);
    }

    @Override
    public void deployPackage(Set<GCUBEScope> targets) throws DeployException, InvalidPackageArchiveException {
        this.logger.debug((Object)("Deploying the library package " + this.getKey().getPackageName() + " in scope(s) " + targets.toString()));
        URI uri = this.packageprofile.getURI();
        if (uri != null) {
            this.deployRemoteLibrary(uri);
        } else {
            this.deployLibrary(this.packageprofile.getFiles());
        }
    }

    @Override
    protected Package getPackageProfile() {
        return this.packageprofile;
    }

    @Override
    public boolean requireRestart() {
        return true;
    }

    private void deployLibrary(List<String> libraryfiles) throws DeployException, InvalidPackageArchiveException {
        for (String file : libraryfiles) {
            try {
                this.run = new AntRunner();
                this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
            }
            catch (Exception e) {
                this.logger.error((Object)("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName()), (Throwable)e);
                throw new DeployException("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName());
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("service.id", this.extractor.getServiceKey());
            properties.put("package.name", this.getKey().getPackageName());
            properties.put("package.file", this.extractor.getDownloadedFile().getName());
            properties.put("package.source.dir", Configuration.BASESOURCEDIR);
            properties.put("base.deploy.dir", Configuration.BASEDEPLOYDIR);
            properties.put("jar.name", file.trim());
            try {
                this.run.setProperties(properties, true);
                this.run.runTarget("deployLibrary");
            }
            catch (AntInterfaceException aie) {
                throw new DeployException(aie.getMessage());
            }
            String[] filetokens = file.split(File.separator);
            this.addFile2Package(new File(this.baseLibTargetDir + filetokens[filetokens.length - 1]));
        }
    }

    private void deployRemoteLibrary(URI uri) throws DeployException {
        try {
            String[] data = this.downloadFrom(uri.toURL().toString());
            try {
                this.run = new AntRunner();
                this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
            }
            catch (Exception e) {
                this.logger.error((Object)("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName()), (Throwable)e);
                throw new DeployException("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName());
            }
            HashMap<String, String> prop = new HashMap<String, String>();
            prop.put("library.file", data[0]);
            prop.put("base.deploy.dir", this.extractor.getPackagedir());
            prop.put("package.name", this.getKey().getPackageName());
            try {
                this.run.setProperties(prop, true);
                this.run.runTarget("uncompressRemoteLibrary");
            }
            catch (AntInterfaceException aie) {
                this.logger.error((Object)aie);
                throw new DeployException(aie.getMessage());
            }
            List<String> myjars = this.getRemoteJarNames(this.extractor.getPackagedir() + File.separator + this.getKey().getPackageName());
            if (myjars.size() == 0) {
                this.logger.warn((Object)("no JAR archive found in " + data[0]));
            }
            this.buildRemoteJarNames(myjars);
            for (String file : myjars) {
                try {
                    this.run = new AntRunner();
                    this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName()), (Throwable)e);
                    throw new DeployException("Package deployer is unable to initialize the deployment environment for " + this.key.getPackageName());
                }
                this.logger.info((Object)("deploying " + file + " as part of an external library"));
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("jar.name", file.trim());
                try {
                    this.run.setProperties(properties, true);
                    this.run.runTarget("deployRemoteLibrary");
                }
                catch (AntInterfaceException aie) {
                    this.logger.error((Object)aie);
                    throw new DeployException(aie.getMessage());
                }
                String[] filetokens = file.split(File.separator);
                this.addFile2Package(new File(this.baseLibTargetDir + filetokens[filetokens.length - 1]));
            }
        }
        catch (Exception e) {
            throw new DeployException("Runtime deployment error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] downloadFrom(String URI2) throws Exception {
        String[] uri_tokens = URI2.split(File.separator);
        if (uri_tokens == null || uri_tokens.length < 1) {
            throw new Exception("invalid URI from which to download the external library");
        }
        String filename = uri_tokens[uri_tokens.length - 1];
        String localpath = this.extractor.getPackagedir() + File.separator + filename;
        this.logger.debug((Object)("Library Package deployer is trying to download from: " + URI2));
        this.logger.debug((Object)("and save it here: " + localpath));
        FilterInputStream is = null;
        int code = -999;
        try {
            URL url = new URL(URI2);
            HttpURLConnection urlC = (HttpURLConnection)url.openConnection();
            urlC.setRequestMethod("GET");
            urlC.setDoInput(true);
            urlC.setDoOutput(true);
            urlC.setDoOutput(true);
            urlC.setUseCaches(false);
            this.logger.debug((Object)"Getting data from returned URL..");
            is = new DataInputStream(urlC.getInputStream());
            code = urlC.getResponseCode();
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)"Malformed URL Exception ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"File Not FoundException ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"IO Exception ", (Throwable)e);
        }
        FilterOutputStream o = null;
        try {
            this.logger.debug((Object)("Connection return code: " + code));
            this.logger.debug((Object)("Bytes available out:    " + is.available()));
            this.logger.debug((Object)"Open URL connection and saving to local cache..");
            o = new DataOutputStream(new FileOutputStream(localpath));
            this.logger.debug((Object)("Saving package to = " + localpath));
            while (true) {
                byte b = ((DataInputStream)is).readByte();
                ((DataOutputStream)o).writeByte(b);
            }
        }
        catch (EOFException ee) {
            try {
                o.close();
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    o.close();
                }
                catch (Exception e2) {}
            }
        }
        return new String[]{localpath, filename};
    }

    private void buildRemoteJarNames(List<String> localJars) throws InvalidPackageArchiveException {
        for (String jar : localJars) {
            this.buildJarNames(jar);
        }
    }

    private void buildJarNames(String jarname) throws InvalidPackageArchiveException {
        String[] my_jar_tokes = jarname.split(File.separator);
        if (my_jar_tokes == null || my_jar_tokes.length < 1) {
            throw new InvalidPackageArchiveException("invalid Jar name: " + jarname);
        }
        this.jars.add(my_jar_tokes[my_jar_tokes.length - 1]);
    }

    private List<String> getRemoteJarNames(String dir) {
        ArrayList<String> ret = new ArrayList<String>();
        this.logger.debug((Object)("looking for JAR archives in " + dir + "..."));
        File[] list = new File(dir).listFiles();
        if (list == null) {
            this.logger.warn((Object)("the " + dir + " does not contain any file or folder"));
            return ret;
        }
        for (File f : list) {
            this.logger.debug((Object)("checking file " + f.getName() + "..."));
            if (f.getName().endsWith(".jar")) {
                this.logger.debug((Object)("External Library Deployer found " + f.getName() + " to deploy"));
                ret.add(f.getAbsolutePath());
                continue;
            }
            if (!f.isDirectory()) continue;
            ret.addAll(this.getRemoteJarNames(f.getAbsolutePath()));
        }
        return ret;
    }

    @Override
    public boolean verify() throws InvalidPackageArchiveException {
        for (File libFile : this.getPackageFileList()) {
            this.logger.warn((Object)("Verifying library file " + libFile.getName() + "..."));
            if (libFile.exists()) continue;
            try {
                this.logger.warn((Object)("Library file " + libFile.getCanonicalPath() + " not correctly deployed"));
            }
            catch (IOException e) {
                throw new InvalidPackageArchiveException("Unable to check library file " + libFile.getName());
            }
            return false;
        }
        return true;
    }
}

