/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.platforms;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.platforms.PlatformApplication;
import org.gcube.common.vremanagement.deployer.impl.resources.BasePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DeployablePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackage;
import org.gcube.vremanagement.virtualplatform.image.VirtualPlatform;
import org.gcube.vremanagement.virtualplatform.model.DeployedPackage;
import org.gcube.vremanagement.virtualplatform.model.Package;
import org.gcube.vremanagement.virtualplatform.model.PackageSet;
import org.gcube.vremanagement.virtualplatform.model.UndeployedPackage;

public class PlatformCall {
    private final GCUBELog logger = new GCUBELog(PlatformCall.class);
    private VirtualPlatform platform;
    private Package app;

    public PlatformCall(VirtualPlatform platform) {
        this.platform = platform;
    }

    public PlatformApplication deploy(DeployablePackage pack, List<File> files, List<String> endpoints) throws Exception {
        this.app = this.platform.getNewAppInstance();
        String name = this.buildAppName(pack);
        this.app.setTargetPath(this.buildAppPath(pack));
        FileFilter filter = this.platform.getAcceptedFilesFilter();
        boolean found = false;
        if (filter != null) {
            for (File file : files) {
                this.logger.trace((Object)("Evaluating file " + file.getAbsolutePath() + " for deployment"));
                if (!filter.accept(file)) continue;
                this.app.setFile(file);
                found = true;
                break;
            }
        } else if (files.size() > 0) {
            this.app.setFile(files.get(0));
            found = true;
        }
        if (!found) {
            throw new Exception("Unable to locate a valid file to deploy in the platform");
        }
        this.app.setName(name);
        this.app.setDescription(pack.getServiceProfile().getDescription());
        org.gcube.common.core.resources.service.Package sourcepack = (org.gcube.common.core.resources.service.Package)pack.getServiceProfile().getPackages().get(0);
        this.app.setName(sourcepack.getName());
        this.app.setVersion(sourcepack.getVersion());
        this.app.setServiceClass(pack.getServiceProfile().getServiceClass());
        this.app.setServiceName(pack.getServiceProfile().getServiceName());
        this.app.setServiceVersion(pack.getServiceProfile().getVersion());
        this.app.setServiceID(pack.getServiceProfile().getID());
        this.app.setEntrypoints(endpoints);
        PackageSet packages = new PackageSet();
        packages.add((Object)this.app);
        PackageSet deployed = this.platform.deploy(packages);
        for (DeployedPackage p : deployed) {
            this.logger.debug((Object)("Application endpoints " + Arrays.toString(p.getEndpoints())));
        }
        if (deployed.size() > 0) {
            this.logger.info((Object)("Application " + name + " successfully deployed"));
            return new PlatformApplication((DeployedPackage)deployed.iterator().next(), this.platform);
        }
        throw new Exception("Failed to deploy " + name);
    }

    public PlatformApplication deployAndActivate(DeployablePackage pack, List<File> files, List<String> endpoints) throws Exception {
        PlatformApplication app = this.deploy(pack, files, endpoints);
        this.activate(pack);
        return app;
    }

    public void activate(DeployablePackage pack) throws Exception {
        this.activate(this.buildAppName(pack), this.buildAppPath(pack));
    }

    public void activate(String name, String path) throws Exception {
        this.app = this.platform.getNewAppInstance();
        this.app.setTargetPath(path);
        this.app.setName(name);
        PackageSet packages = new PackageSet();
        packages.add((Object)this.app);
        if (!this.platform.activate(packages)) {
            throw new Exception("Failed to activate " + name);
        }
        this.logger.debug((Object)("Application " + name + " successfully activated"));
    }

    public void deactivate(UndeployablePackage pack) throws Exception {
        this.deactivate(this.buildAppName(pack), this.buildAppPath(pack));
    }

    public void deactivate(String name, String path) throws Exception {
        this.app = this.platform.getNewAppInstance();
        this.app.setTargetPath(path);
        this.app.setName(name);
        PackageSet packages = new PackageSet();
        packages.add((Object)this.app);
        if (!this.platform.deactivate(packages)) {
            throw new Exception("Failed to deactivate " + name);
        }
        this.logger.debug((Object)("Application " + name + " successfully deactivated"));
    }

    public PlatformApplication undeploy(UndeployablePackage pack) throws Exception {
        this.app = this.platform.getNewAppInstance();
        String name = this.buildAppName(pack);
        this.app.setTargetPath(this.buildAppPath(pack));
        this.app.setName(name);
        this.app.setServiceClass(pack.getKey().getServiceClass());
        this.app.setServiceName(pack.getKey().getServiceName());
        this.app.setServiceVersion(pack.getKey().getServiceVersion());
        if (pack.getScopes().size() <= 0) {
            throw new IllegalStateException("the package has no scope associated");
        }
        this.app.setScope(pack.getScopes().iterator().next());
        PackageSet packages = new PackageSet();
        packages.add((Object)this.app);
        PackageSet undeployed = this.platform.undeploy(packages);
        this.logger.info((Object)("Application " + name + " successfully undeployed"));
        if (undeployed.size() > 0) {
            return new PlatformApplication((UndeployedPackage)undeployed.iterator().next());
        }
        throw new Exception("Failed to undeploy " + name);
    }

    public PlatformApplication deactivateAndUndeploy(UndeployablePackage pack) throws Exception {
        this.deactivate(pack);
        PlatformApplication app = this.undeploy(pack);
        return app;
    }

    private String buildAppPath(BasePackage pack) {
        return "/" + this.buildAppName(pack);
    }

    private String buildAppName(BasePackage pack) {
        return pack.getKey().getPackageName() + "-" + pack.getKey().getPackageVersion();
    }
}

