/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources;

import java.rmi.Remote;
import java.util.List;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.vremanagement.ghnmanager.stubs.AddScopeInputParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.GHNManagerPortType;
import org.gcube.common.vremanagement.ghnmanager.stubs.service.GHNManagerServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;

public class ScopedGHN
extends ScopedResource {
    public static final String TYPE = "GHN";
    private String nodename = "";
    private transient EndpointReferenceType ghnEpr;

    protected ScopedGHN(String id, GCUBEScope scope) {
        super(id, TYPE, scope);
    }

    @Override
    protected void addToScope() throws ScopedResource.ResourceNotFound, Exception {
        if (this.ghnEpr == null) {
            this.findResource();
        }
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            endpoint.setAddress((AttributedURI)new Address("http://" + this.nodename + "/wsrf/services/gcube/common/vremanagement/GHNManager"));
            GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
            GHNManagerPortType pt = (GHNManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)locator.getGHNManagerPortTypePort(endpoint), (GCUBEScope)ServiceContext.getContext().getScope().getEnclosingScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
            AddScopeInputParams params = new AddScopeInputParams();
            params.setScope(this.scope.toString());
            params.setMap("");
            pt.addScope(params);
        }
        catch (Exception e) {
            this.noHopeForMe("Failed to add GHN to scope " + this.scope.toString(), e);
        }
    }

    @Override
    protected void find() throws Exception {
        ISClient client = null;
        GCUBEGHNQuery query = null;
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
            query = (GCUBEGHNQuery)client.getQuery(GCUBEGHNQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID/text()", this.id)});
        }
        catch (Exception e) {
            throw new Exception("unable to query of the target GHN (ID=" + this.id + ")", e);
        }
        try {
            List hostingNodes = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
            this.hostedOn = this.nodename = ((GCUBEHostingNode)hostingNodes.get(0)).getNodeDescription().getName();
            this.ghnEpr = this.loadGHNmanager(((GCUBEHostingNode)hostingNodes.get(0)).getID(), client, ServiceContext.getContext().getScope());
        }
        catch (Exception e) {
            try {
                List hostingNodes = client.execute((ISQuery)query, ServiceContext.getContext().getScope().getEnclosingScope());
                this.hostedOn = this.nodename = ((GCUBEHostingNode)hostingNodes.get(0)).getNodeDescription().getName();
                this.ghnEpr = this.loadGHNmanager(((GCUBEHostingNode)hostingNodes.get(0)).getID(), client, ServiceContext.getContext().getScope().getEnclosingScope());
            }
            catch (Exception ei) {
                throw new Exception("unable to find the target GHN (ID=" + this.id + ")", e);
            }
        }
    }

    @Override
    protected void removeFromScope() throws ScopedResource.ResourceNotFound, Exception {
        if (this.ghnEpr == null) {
            this.findResource();
        }
        try {
            GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
            GHNManagerPortType pt = (GHNManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)locator.getGHNManagerPortTypePort(this.ghnEpr), (GCUBEScope)ServiceContext.getContext().getScope().getEnclosingScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
            pt.removeScope(this.scope.toString());
        }
        catch (Exception e) {
            this.noHopeForMe("Failed to remove GHN from scope " + this.scope.toString(), e);
        }
    }

    private EndpointReferenceType loadGHNmanager(String id, ISClient client, GCUBEScope scope) throws Exception {
        GCUBERIQuery riquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        riquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//GHN/@UniqueID", id), new AtomicCondition("//ServiceClass", "VREManagement"), new AtomicCondition("//ServiceName", "GHNManager")});
        List results = client.execute((ISQuery)riquery, scope);
        return ((GCUBERunningInstance)results.get(0)).getAccessPoint().getEndpoint("gcube/common/vremanagement/GHNManager");
    }
}

