/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.brokerage;

import java.lang.reflect.Constructor;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.brokerage.Broker;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;

public class BrokerConnector {
    private static final String DEFAULT_BROKER = "org.gcube.vremanagement.resourcemanager.impl.brokerage.InternalBroker";
    private static final GCUBELog logger = new GCUBELog(BrokerConnector.class);

    public static Broker getBroker(ScopeState scopeState) throws Exception {
        Broker broker = null;
        try {
            broker = BrokerConnector.load((String)ServiceContext.getContext().getProperty("resourceBrokerClass", new boolean[]{true}));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to load the configured broker", (Throwable)e);
            try {
                logger.info((Object)"Trying to load the internal broker");
                broker = BrokerConnector.load(DEFAULT_BROKER);
            }
            catch (Exception e1) {
                logger.error((Object)"Unable to load the internal broker", (Throwable)e1);
                throw new Exception("unable to find a broker to use");
            }
        }
        if (broker != null) {
            broker.initialize(scopeState);
        }
        return broker;
    }

    private static Broker load(String className) throws Exception {
        if (className == null) {
            return null;
        }
        Class<?> clazz = Class.forName(className);
        if (!Broker.class.isAssignableFrom(clazz)) {
            throw new Exception(className + " does not implement " + Broker.class.getName());
        }
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        return (Broker)constructor.newInstance(new Object[0]);
    }
}

