/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.operators;

import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.brokerage.BrokerConnector;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.operators.OperatorConfig;
import org.gcube.vremanagement.resourcemanager.impl.reporting.Session;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedSoftware;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.GCUBEPackage;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.stubs.binder.PackageItem;
import org.gcube.vremanagement.resourcemanager.stubs.binder.SoftwareList;

public class DeploySoftwareOperator
extends Operator {
    protected final GCUBELog logger = new GCUBELog((Object)this);
    private SoftwareList software;
    private OperatorConfig configuration;

    public DeploySoftwareOperator(ScopeState scopeState, OperatorConfig configuration, SoftwareList software, Operator.ACTION action) {
        this.software = software;
        this.configuration = configuration;
        this.action = action;
        this.scopeState = scopeState;
    }

    @Override
    public void exec() throws Exception {
        this.configuration.session.save();
        HashSet<ScopedDeployedSoftware> softwareToDeploy = new HashSet<ScopedDeployedSoftware>();
        HashSet<ScopedResource> softwareToUndeploy = new HashSet<ScopedResource>();
        for (PackageItem packageitem : this.software.getSoftware()) {
            ScopedDeployedSoftware software = null;
            try {
                if (this.action == Operator.ACTION.ADD) {
                    software = this.createDeployedSoftware(packageitem);
                    software.findResource();
                    if (software.isSuccess()) {
                        softwareToDeploy.add(software);
                    }
                } else {
                    software = this.getDeployedSoftware(GCUBEPackage.fromServiceItem(packageitem), packageitem.getTargetGHNName());
                    softwareToUndeploy.add(software);
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Failed to find the package", (Throwable)e);
                software = this.createDeployedSoftware(packageitem);
                software.setErrorMessage("Failed to find the package on the IS or in the ScopeState");
                software.setStatus(ScopedResource.STATUS.LOST);
            }
            this.configuration.session.addResource(software);
            this.configuration.session.addService(software);
        }
        if (this.action == Operator.ACTION.ADD && this.allocate(this.configuration.session, softwareToDeploy)) {
            HashSet<ScopedResource> resourcesToAdd = new HashSet<ScopedResource>();
            for (ScopedDeployedSoftware software : softwareToDeploy) {
                if (software.getStatus() == ScopedResource.STATUS.LOST) continue;
                software.setCallbackID(this.configuration.session.getId());
                resourcesToAdd.add(software);
                if (this.configuration.scope.getType() != GCUBEScope.Type.VRE) continue;
                ScopedResource ghn = ScopedResourceFactory.newResource(this.scopeState.getScope(), software.getTargetNodeID(), "GHN");
                resourcesToAdd.add(ghn);
                this.configuration.session.addResource(ghn);
            }
            if (softwareToDeploy.size() > 0) {
                this.configuration.scopeState.addResources(resourcesToAdd);
                new Thread(){

                    @Override
                    public void run() {
                        Session tsession = ((DeploySoftwareOperator)DeploySoftwareOperator.this).configuration.session;
                        do {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        } while (!tsession.isSessionClosed() || tsession.getOperation() != Session.OPERATION.AddResources && tsession.getOperation() != Session.OPERATION.UpdateResources && tsession.getOperation() != Session.OPERATION.Create);
                        try {
                            BrokerConnector.getBroker(DeploySoftwareOperator.this.scopeState).sendFeedback(tsession);
                        }
                        catch (Exception e) {
                            DeploySoftwareOperator.this.logger.error((Object)"Failed to send the feedback to the Broker", (Throwable)e);
                        }
                    }
                }.start();
            }
        }
        if (softwareToUndeploy.size() > 0) {
            this.configuration.scopeState.removeResources(softwareToUndeploy);
        }
        this.configuration.session.save();
        this.configuration.session.startChecker();
    }

    private boolean allocate(Session session, Set<ScopedDeployedSoftware> servicesToDeploy) {
        try {
            if (servicesToDeploy.size() > 0) {
                BrokerConnector.getBroker(this.scopeState).makePlan(session, servicesToDeploy, this.software.getSuggestedTargetGHNNames());
                this.configuration.session.reportBrokerWork(true, "The Deployment Plan was successfully created");
                return true;
            }
            this.logger.warn((Object)"The Broker was not contacted. After the dependency resolution phase, there is nothing to deploy");
            this.configuration.session.reportBrokerWork(false, "The Broker was not contacted. After the dependency resolution phase, there is nothing to deploy");
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred when interacting with the broker", (Throwable)e);
            this.configuration.session.reportBrokerWork(false, "An error occurred when interacting with the broker " + e.getMessage());
            return false;
        }
    }

    private ScopedDeployedSoftware getDeployedSoftware(GCUBEPackage sourcePackage, String targetNode) throws Exception {
        String id = sourcePackage.getID();
        this.logger.trace((Object)("Searching state for package " + id + " on node " + targetNode));
        Set<ScopedResource> availableSoftware = this.scopeState.getResourcesByType("Service");
        for (ScopedResource resource : availableSoftware) {
            ScopedDeployedSoftware software = (ScopedDeployedSoftware)resource;
            GCUBEPackage serializedPackage = software.getSourcePackage();
            if (serializedPackage != null) {
                this.logger.trace((Object)("Found package " + serializedPackage.getID() + " on node " + software.getTargetNodeName()));
            }
            if (serializedPackage == null || !serializedPackage.getID().equals(id) || !software.getTargetNodeName().equalsIgnoreCase(targetNode)) continue;
            this.logger.trace((Object)("Taking resource " + id + " from the scope state"));
            return software;
        }
        throw new Exception("Unable to find the software in the scope state");
    }

    private ScopedDeployedSoftware createDeployedSoftware(PackageItem packageitem) throws Exception {
        GCUBEPackage sourcePackage = GCUBEPackage.fromServiceItem(packageitem);
        ScopedDeployedSoftware software = (ScopedDeployedSoftware)ScopedResourceFactory.newResource(this.scopeState.getScope(), sourcePackage.getID(), "Service");
        software.setSourcePackage(sourcePackage);
        return software;
    }
}

