/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources;

import java.net.URL;
import java.rmi.Remote;
import java.util.List;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.vremanagement.ghnmanager.stubs.GHNManagerPortType;
import org.gcube.common.vremanagement.ghnmanager.stubs.service.GHNManagerServiceAddressingLocator;
import org.gcube.common.vremanagement.whnmanager.client.plugins.AbstractPlugin;
import org.gcube.common.vremanagement.whnmanager.client.proxies.WHNManagerProxy;
import org.gcube.resourcemanagement.whnmanager.api.types.AddScopeInputParams;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;

public class ScopedGHN
extends ScopedResource {
    public static final String TYPE = "GHN";
    private String nodename = "";
    private boolean isWhnManagerEnabled;
    private transient EndpointReferenceType ghnEpr;

    protected ScopedGHN(String id, GCUBEScope scope) {
        super(id, TYPE, scope);
    }

    @Override
    protected void addToScope() throws ScopedResource.ResourceNotFound, Exception {
        if (this.ghnEpr == null) {
            this.findResource();
        }
        if (this.isWhnManagerEnabled) {
            WHNManagerProxy proxy = this.loadWHNManager(this.hostedOn);
            try {
                AddScopeInputParams params = new AddScopeInputParams(this.scope.toString(), "");
                proxy.addScope(params);
            }
            catch (Exception e) {
                this.noHopeForMe("Failed to add WHN to scope " + this.scope.toString(), e);
            }
            this.isWhnManagerEnabled = false;
            this.logger.debug((Object)" AddScope operation on WhnManager completed ");
        } else {
            EndpointReferenceType endpoint = new EndpointReferenceType();
            try {
                endpoint.setAddress((AttributedURI)new Address("http://" + this.nodename + "/wsrf/services/gcube/common/vremanagement/GHNManager"));
                GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
                GHNManagerPortType pt = (GHNManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)locator.getGHNManagerPortTypePort(endpoint), (GCUBEScope)ServiceContext.getContext().getScope().getEnclosingScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
                org.gcube.common.vremanagement.ghnmanager.stubs.AddScopeInputParams params = new org.gcube.common.vremanagement.ghnmanager.stubs.AddScopeInputParams();
                params.setScope(this.scope.toString());
                params.setMap("");
                pt.addScope(params);
            }
            catch (Exception e) {
                this.noHopeForMe("Failed to add GHN to scope " + this.scope.toString(), e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void find() throws Exception {
        this.logger.trace((Object)("ScopedGHN find method. Search ghn with id: " + this.id));
        this.isWhnManagerEnabled = this.checkGhnType(this.id, ServiceContext.getContext().getScope());
        if (!this.isWhnManagerEnabled) {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGHNQuery query = null;
            try {
                query = (GCUBEGHNQuery)client.getQuery(GCUBEGHNQuery.class);
                query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID/text()", this.id)});
            }
            catch (Exception e) {
                throw new Exception("unable to query of the target GHN (ID=" + this.id + ")", e);
            }
            try {
                this.logger.debug((Object)"find method: execute query");
                List hostingNodes = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
                this.hostedOn = this.nodename = ((GCUBEHostingNode)hostingNodes.get(0)).getNodeDescription().getName();
                this.ghnEpr = this.loadGHNmanager(((GCUBEHostingNode)hostingNodes.get(0)).getID(), client, ServiceContext.getContext().getScope());
                return;
            }
            catch (Exception e) {
                this.isWhnManagerEnabled = this.checkGhnType(this.id, ServiceContext.getContext().getScope().getEnclosingScope());
                if (this.isWhnManagerEnabled) return;
                try {
                    List hostingNodes = client.execute((ISQuery)query, ServiceContext.getContext().getScope().getEnclosingScope());
                    this.hostedOn = this.nodename = ((GCUBEHostingNode)hostingNodes.get(0)).getNodeDescription().getName();
                    this.ghnEpr = this.loadGHNmanager(((GCUBEHostingNode)hostingNodes.get(0)).getID(), client, ServiceContext.getContext().getScope().getEnclosingScope());
                    return;
                }
                catch (Exception ei) {
                    throw new Exception("unable to find the target GHN (ID=" + this.id + ")", e);
                }
            }
        }
        this.nodename = this.hostedOn;
    }

    @Override
    protected void removeFromScope() throws ScopedResource.ResourceNotFound, Exception {
        if (this.ghnEpr == null) {
            this.findResource();
        }
        if (this.isWhnManagerEnabled) {
            String scopeString = ServiceContext.getContext().getScope().getEnclosingScope().toString();
            this.logger.debug((Object)("contacting the WHNManager  on " + this.nodename + "  with scope " + scopeString + " for remove the scope: " + this.scope + " to the resource with id: " + this.id));
            ScopeProvider.instance.set(scopeString);
            WHNManagerProxy proxy = (WHNManagerProxy)AbstractPlugin.whnmanager().at(new URL("http://" + this.nodename + "/whn-manager/gcube/vremanagement/ws/whnmanager")).build();
            try {
                proxy.removeScope(this.scope.toString());
            }
            catch (Exception e) {
                this.noHopeForMe("Failed to remove WHN from scope " + this.scope.toString(), e);
            }
            this.isWhnManagerEnabled = false;
            this.logger.debug((Object)"RemoveScope operation on WhnManager completed ");
        } else {
            try {
                GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
                GHNManagerPortType pt = (GHNManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)locator.getGHNManagerPortTypePort(this.ghnEpr), (GCUBEScope)ServiceContext.getContext().getScope().getEnclosingScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
                pt.removeScope(this.scope.toString());
            }
            catch (Exception e) {
                this.noHopeForMe("Failed to remove GHN from scope " + this.scope.toString(), e);
            }
        }
    }

    private EndpointReferenceType loadGHNmanager(String id, ISClient client, GCUBEScope scope) throws Exception {
        GCUBERIQuery riquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        riquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/GHN/@UniqueID", id), new AtomicCondition("/Profile/ServiceClass", "VREManagement"), new AtomicCondition("/Profile/ServiceName", "GHNManager")});
        List results = client.execute((ISQuery)riquery, scope);
        return ((GCUBERunningInstance)results.get(0)).getAccessPoint().getEndpoint("gcube/common/vremanagement/GHNManager");
    }
}

